/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.SqlUtils;

public class ObMysqlKeyReadIterator
extends KeyReadIterator {
    @Override
    public String getMinBoundSql() {
        ObMysqlSqlBuilder builder = new ObMysqlSqlBuilder();
        builder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        builder.setTableName(this.tableName);
        builder.setPartitionName(this.partitionName);
        builder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.tableMeta, this.minKey));
        builder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.tableMeta, this.maxKey));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setLimit(1);
        return builder.getSplitSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        ObMysqlSqlBuilder builder = new ObMysqlSqlBuilder();
        builder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        builder.setTableName(this.tableName);
        builder.setPartitionName(this.partitionName);
        builder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.tableMeta, lowerBound));
        builder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.tableMeta, this.maxKey));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.DESC);
        builder.setLimit(1);
        return builder.getSplitSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        ObMysqlSqlBuilder builder = new ObMysqlSqlBuilder();
        builder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        builder.setTableName(this.tableName);
        builder.setPartitionName(this.partitionName);
        builder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.tableMeta, lowerBound));
        builder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.tableMeta, this.maxKey));
        builder.addUserDefinedCondition(this.getUserDefinedCondition());
        builder.setOrderByColumns(this.tableMeta.getSortedPrimaryColumnMetas());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setOffset(this.batchSize - 1);
        builder.setLimit(1);
        return builder.getSplitSql();
    }
}

