/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.meta;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMeta {
    private static final Logger log = LoggerFactory.getLogger(ClusterMeta.class);
    private String clusterName = null;
    private long clusterId = -1L;
    private long readUsedQuota = -1L;
    private long writeUsedQuota = -1L;
    private long readSizeLimit = -1L;
    private long writeSizeLimit = -1L;

    public int getAvgReadSizeLimit() {
        return (int)(this.readSizeLimit / (this.readUsedQuota == 0L ? 1L : this.readUsedQuota));
    }

    public int getAvgWriteSizeLimit() {
        return (int)(this.writeSizeLimit / (this.writeUsedQuota == 0L ? 1L : this.writeUsedQuota));
    }

    public long getReadUsedQuota() {
        return this.readUsedQuota;
    }

    public long getWriteUsedQuota() {
        return this.writeUsedQuota;
    }

    public long getReadSizeLimit() {
        return this.readSizeLimit;
    }

    public long getWriteSizeLimit() {
        return this.writeSizeLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterMeta)) {
            return false;
        }
        ClusterMeta other = (ClusterMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        if (this.getClusterId() != other.getClusterId()) {
            return false;
        }
        if (this.getReadUsedQuota() != other.getReadUsedQuota()) {
            return false;
        }
        if (this.getWriteUsedQuota() != other.getWriteUsedQuota()) {
            return false;
        }
        if (this.getReadSizeLimit() != other.getReadSizeLimit()) {
            return false;
        }
        return this.getWriteSizeLimit() == other.getWriteSizeLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        long $clusterId = this.getClusterId();
        result = result * 59 + (int)($clusterId >>> 32 ^ $clusterId);
        long $readUsedQuota = this.getReadUsedQuota();
        result = result * 59 + (int)($readUsedQuota >>> 32 ^ $readUsedQuota);
        long $writeUsedQuota = this.getWriteUsedQuota();
        result = result * 59 + (int)($writeUsedQuota >>> 32 ^ $writeUsedQuota);
        long $readSizeLimit = this.getReadSizeLimit();
        result = result * 59 + (int)($readSizeLimit >>> 32 ^ $readSizeLimit);
        long $writeSizeLimit = this.getWriteSizeLimit();
        result = result * 59 + (int)($writeSizeLimit >>> 32 ^ $writeSizeLimit);
        return result;
    }

    public String toString() {
        return "ClusterMeta(clusterName=" + this.getClusterName() + ", clusterId=" + this.getClusterId() + ", readUsedQuota=" + this.getReadUsedQuota() + ", writeUsedQuota=" + this.getWriteUsedQuota() + ", readSizeLimit=" + this.getReadSizeLimit() + ", writeSizeLimit=" + this.getWriteSizeLimit() + ")";
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public void setReadUsedQuota(long readUsedQuota) {
        this.readUsedQuota = readUsedQuota;
    }

    public void setWriteUsedQuota(long writeUsedQuota) {
        this.writeUsedQuota = writeUsedQuota;
    }

    public void setReadSizeLimit(long readSizeLimit) {
        this.readSizeLimit = readSizeLimit;
    }

    public void setWriteSizeLimit(long writeSizeLimit) {
        this.writeSizeLimit = writeSizeLimit;
    }
}

