/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.meta;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantMeta {
    private static final Logger log = LoggerFactory.getLogger(TenantMeta.class);
    private String tenantName = null;
    private String clusterName = null;
    private long readUsedQuota = -1L;
    private long writeUsedQuota = -1L;
    private long readSizeLimit = -1L;
    private long writeSizeLimit = -1L;
    private boolean isLimit = false;

    public int getAvgReadSizeLimit() {
        if (this.isLimit) {
            return 0;
        }
        return (int)(this.readSizeLimit / (this.readUsedQuota == 0L ? 1L : this.readUsedQuota));
    }

    public int getAvgWriteSizeLimit() {
        if (this.isLimit) {
            return 0;
        }
        return (int)(this.writeSizeLimit / (this.writeUsedQuota == 0L ? 1L : this.writeUsedQuota));
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public long getReadUsedQuota() {
        return this.readUsedQuota;
    }

    public long getWriteUsedQuota() {
        return this.writeUsedQuota;
    }

    public long getReadSizeLimit() {
        return this.readSizeLimit;
    }

    public long getWriteSizeLimit() {
        return this.writeSizeLimit;
    }

    public boolean isLimit() {
        return this.isLimit;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setReadUsedQuota(long readUsedQuota) {
        this.readUsedQuota = readUsedQuota;
    }

    public void setWriteUsedQuota(long writeUsedQuota) {
        this.writeUsedQuota = writeUsedQuota;
    }

    public void setReadSizeLimit(long readSizeLimit) {
        this.readSizeLimit = readSizeLimit;
    }

    public void setWriteSizeLimit(long writeSizeLimit) {
        this.writeSizeLimit = writeSizeLimit;
    }

    public void setLimit(boolean isLimit) {
        this.isLimit = isLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantMeta)) {
            return false;
        }
        TenantMeta other = (TenantMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        if (this.getReadUsedQuota() != other.getReadUsedQuota()) {
            return false;
        }
        if (this.getWriteUsedQuota() != other.getWriteUsedQuota()) {
            return false;
        }
        if (this.getReadSizeLimit() != other.getReadSizeLimit()) {
            return false;
        }
        if (this.getWriteSizeLimit() != other.getWriteSizeLimit()) {
            return false;
        }
        return this.isLimit() == other.isLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        long $readUsedQuota = this.getReadUsedQuota();
        result = result * 59 + (int)($readUsedQuota >>> 32 ^ $readUsedQuota);
        long $writeUsedQuota = this.getWriteUsedQuota();
        result = result * 59 + (int)($writeUsedQuota >>> 32 ^ $writeUsedQuota);
        long $readSizeLimit = this.getReadSizeLimit();
        result = result * 59 + (int)($readSizeLimit >>> 32 ^ $readSizeLimit);
        long $writeSizeLimit = this.getWriteSizeLimit();
        result = result * 59 + (int)($writeSizeLimit >>> 32 ^ $writeSizeLimit);
        result = result * 59 + (this.isLimit() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TenantMeta(tenantName=" + this.getTenantName() + ", clusterName=" + this.getClusterName() + ", readUsedQuota=" + this.getReadUsedQuota() + ", writeUsedQuota=" + this.getWriteUsedQuota() + ", readSizeLimit=" + this.getReadSizeLimit() + ", writeSizeLimit=" + this.getWriteSizeLimit() + ", isLimit=" + this.isLimit() + ")";
    }
}

