/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;

public class HistoryLockDao {
    private static final String ACQUIRE_LOCK_SQL = "INSERT INTO history_lock (`lock_name`, `lock_by`, `lock_until`) VALUES (?, ?, ?)";
    private static final String RELEASE_LOCK_SQL = "DELETE FROM history_lock WHERE lock_name = ? and lock_by = ?";
    private static final String REMOVE_EXPIRED_LOCK_SQL = "DELETE FROM history_lock WHERE lock_name = ? and lock_until < now()";

    public static void acquireLock(Connection connection, String lockName, String lockBy, LocalDateTime lockUntil) throws SQLException {
        DaoUtils.update(connection, ACQUIRE_LOCK_SQL, lockName, lockBy, lockUntil);
    }

    public static void releaseLock(Connection connection, String lockName, String lockBy) throws SQLException {
        DaoUtils.update(connection, RELEASE_LOCK_SQL, lockName, lockBy);
    }

    public static void removeExpiredLock(Connection connection, String lockName) throws SQLException {
        DaoUtils.update(connection, REMOVE_EXPIRED_LOCK_SQL, lockName);
    }
}

