/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.dao;

import com.oceanbase.tools.migrator.common.util.DaoUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class HistoryWorkerDao {
    private static final String REPORT_HEARTBEAT_SQL = "INSERT INTO history_worker(worker_ip,worker_version,job_limit,worker_group,job_count,status) values(?, ?, ?, ?, 0, 'ONLINE') ON DUPLICATE KEY UPDATE gmt_alive = now(), job_count = ?";
    private static final String DELETE_HEARTBEAT_SQL = "DELETE FROM history_worker WHERE worker_ip = ?";

    public static void reportHeartbeat(Connection connection, String workerIp, String workerVersion, Integer jobLimit, String workerGroup, Integer jobCount) throws SQLException {
        Object[] sqlParam = new Object[]{workerIp, workerVersion, jobLimit, workerGroup, jobCount};
        DaoUtils.update(connection, REPORT_HEARTBEAT_SQL, sqlParam);
    }

    public static void deleteHeartbeat(Connection connection, String workerIp) throws SQLException {
        DaoUtils.update(connection, DELETE_HEARTBEAT_SQL, workerIp);
    }
}

