/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataSourceAdapter
extends AbstractDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(MetaDataSourceAdapter.class);
    private DataSource datasource = null;

    public MetaDataSourceAdapter(DataSourceInfo conf) {
        super(conf);
        log.info(String.format("begin to init datasource OB10: %s", conf.getDataSourceName()));
        if (conf.getJdbcUrl() == null || conf.getFullUserName() == null) {
            log.warn(String.format("missing configure for oceanbaseV10 dataSource, conf=%s", conf));
        } else {
            this.datasource = this.configureDataSource(conf);
        }
    }

    private DataSource configureDataSource(DataSourceInfo conf) {
        DruidDataSource datasource = new DruidDataSource();
        try {
            datasource.setUrl(conf.getJdbcUrl());
            datasource.setUsername(conf.getFullUserName());
            ArrayList<String> initSql = new ArrayList<String>();
            initSql.add("set @@ob_org_cluster_id = 2147473648");
            datasource.setConnectionInitSqls(initSql);
            datasource.setInitialSize(1);
            datasource.setMaxActive(conf.getConnectionCount());
            datasource.setMaxWait(60000L);
            datasource.setMinIdle(2);
            datasource.setMaxActive(32);
            datasource.setPassword(conf.getPassword());
            this.updateRateLimiter(conf.getRateLimit());
        }
        catch (Exception e) {
            log.warn(String.format("fail to init oceanbaseV10 dataSource, ds=%s, conf=%s", this.dataSourceInfo.getDataSourceName(), conf), (Throwable)e);
        }
        return datasource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        return this.getConnection();
    }

    @Override
    public void closeDataSource() {
    }
}

