/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.job;

import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.enums.JobStatus;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.JobTaskAbnormalException;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.runner.TaskGeneratorRunner;
import com.oceanbase.tools.migrator.core.tunnel.JobTunnel;
import com.oceanbase.tools.migrator.core.tunnel.TaskTunnel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    protected JobMeta jobMeta = null;
    protected TaskTunnel taskTunnel = null;
    protected List<Future> childRunners = new LinkedList<Future>();
    private static final Set<JobStatus> VALID_JOB_STATUS_SET = new HashSet<JobStatus>(){
        {
            this.add(JobStatus.DISPATCHED);
            this.add(JobStatus.RUNNING);
        }
    };

    public void run() throws JobException, InterruptedException {
        if (this.jobMeta == null) {
            throw new RuntimeException("jobMeta is null");
        }
        if (!VALID_JOB_STATUS_SET.contains((Object)this.jobMeta.getJobStatus())) {
            throw new RuntimeException(String.format("[%s] Invalid Job Status: %s", new Object[]{this.jobMeta.getJobId(), this.jobMeta.getJobStatus()}));
        }
        this.jobMeta.updateLimitAndStatus();
        try {
            this.processJob();
        }
        finally {
            for (Future future : this.childRunners) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            this.jobMeta.reportStatistic();
        }
    }

    private void processJob() throws JobException, InterruptedException {
        JobTunnel jobTunnel = new JobTunnel(this.jobMeta);
        this.taskTunnel = new TaskTunnel(this.jobMeta);
        TaskGeneratorRunner taskGeneratorRunner = new TaskGeneratorRunner();
        taskGeneratorRunner.setReadTunnel(jobTunnel);
        taskGeneratorRunner.setWriteTunnel(this.taskTunnel);
        taskGeneratorRunner.setName("Job-" + this.jobMeta.getJobId() + "-TaskGenerator");
        this.childRunners.add(this.jobMeta.getExecutorService().submit(taskGeneratorRunner));
        this.processJobInternal();
        TableSizeInfo tableSizeInfo = this.jobMeta.getSourceTableSizeInfo();
        log.info(String.format("Job[%s] get Table TotalRowCount:%s", this.jobMeta.getJobId(), tableSizeInfo.getTableRowCount()));
        this.jobMeta.getJobStat().setTotalRowCount(tableSizeInfo.getTableRowCount());
        this.jobMeta.reportSourceTableSizeInfo();
        while (!this.taskTunnel.isFinished()) {
            this.taskTunnel.report();
            this.jobMeta.updateLimitAndStatus();
            this.jobMeta.getJobStat().addElapsedTime(10L);
            this.jobMeta.reportStatistic();
            this.doTimerTask();
            if (this.jobMeta.getJobError() != null) {
                throw this.jobMeta.getJobError();
            }
            Thread.sleep(10000L);
        }
        if (this.jobMeta.getJobError() != null) {
            throw this.jobMeta.getJobError();
        }
        log.info("job finish and job status is running,try to set job status success");
        Long abnormalTaskIndex = this.jobMeta.queryAbnormalTaskIndex();
        if (abnormalTaskIndex != null) {
            throw new JobTaskAbnormalException(this.jobMeta.getJobId(), abnormalTaskIndex);
        }
        this.jobMeta.closeDataAdapter();
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public ExecutorService getExecutorService() {
        return this.jobMeta.getExecutorService();
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    abstract void processJobInternal();

    abstract void doTimerTask();
}

