/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.job;

import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.core.JobMetaFactorySingleton;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.job.AbstractJob;
import com.oceanbase.tools.migrator.job.CheckJob;
import com.oceanbase.tools.migrator.job.DeleteJob;
import com.oceanbase.tools.migrator.job.MigrateJob;
import com.oceanbase.tools.migrator.job.QuickDeleteJob;
import com.oceanbase.tools.migrator.job.RollbackJob;

public class JobFactory {
    public static AbstractJob getJob(String jobId) throws JobException {
        AbstractJob job;
        JobMeta jobMeta = JobMetaFactorySingleton.getInstance().create(jobId);
        switch (jobMeta.getJobType()) {
            case MIGRATE: {
                job = new MigrateJob();
                break;
            }
            case CHECK: {
                job = new CheckJob();
                break;
            }
            case DELETE: {
                job = new DeleteJob();
                break;
            }
            case QUICK_DELETE: {
                job = new QuickDeleteJob();
                break;
            }
            case ROLLBACK: {
                job = new RollbackJob();
                break;
            }
            default: {
                throw new RuntimeException("Invalid Job Type");
            }
        }
        job.setJobMeta(jobMeta);
        return job;
    }
}

