/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.sql;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.MysqlSqlBuilder;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.List;

public class MySqlUtils {
    private static final MysqlSqlBuilder mysqlSqlBuilder = new MysqlSqlBuilder();

    public static String getQueryCondition(TableMeta tableMeta, PrimaryKey minKey, PrimaryKey maxKey) {
        return MySqlUtils.getQueryCondition(tableMeta.getSortedPrimaryColumnMetas(), minKey, maxKey);
    }

    public static String getMinKeyCondition(TableMeta tableMeta, PrimaryKey minKey) {
        if (minKey == null) {
            return "";
        }
        return MySqlUtils.getPkCondition(tableMeta.getSortedPrimaryColumnMetas(), minKey, SqlUtils.ExprCondition.GREATER_THAN);
    }

    public static String getMaxKeyCondition(TableMeta tableMeta, PrimaryKey maxKey) {
        if (maxKey == null) {
            return "";
        }
        return MySqlUtils.getPkCondition(tableMeta.getSortedPrimaryColumnMetas(), maxKey, SqlUtils.ExprCondition.LESS_THAN);
    }

    public static String getQueryCondition(List<ColumnMeta> columnName, PrimaryKey lowerKey, PrimaryKey upperKey) {
        int columnCount = upperKey.getPrimaryKeyColumns().size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columnCount; ++i) {
            int j;
            if (i != 0) {
                sb.append(" OR ");
            }
            if (i == 0) {
                sb.append("(");
                sb.append(columnName.get(i).getName());
                sb.append(i == columnCount - 1 && lowerKey.isIncluded() ? ">=" : ">");
                sb.append(mysqlSqlBuilder.getSqlString(lowerKey.getPrimaryKeyColumn(i)));
                sb.append(" and ");
                sb.append(columnName.get(i).getName());
                sb.append(i == columnCount - 1 && upperKey.isIncluded() ? "<=" : "<");
                sb.append(mysqlSqlBuilder.getSqlString(upperKey.getPrimaryKeyColumn(i)));
                sb.append(")");
                continue;
            }
            sb.append("(");
            for (j = 0; j < i; ++j) {
                sb.append(columnName.get(j).getName());
                sb.append("=");
                sb.append(mysqlSqlBuilder.getSqlString(lowerKey.getPrimaryKeyColumn(j)));
                sb.append(" AND ");
            }
            sb.append(columnName.get(i).getName());
            sb.append(i == columnCount - 1 && lowerKey.isIncluded() ? ">=" : ">");
            sb.append(mysqlSqlBuilder.getSqlString(lowerKey.getPrimaryKeyColumn(i)));
            sb.append(")");
            sb.append(" OR ");
            sb.append("(");
            for (j = 0; j < i; ++j) {
                sb.append(columnName.get(j).getName());
                sb.append("=");
                sb.append(mysqlSqlBuilder.getSqlString(upperKey.getPrimaryKeyColumn(j)));
                sb.append(" AND ");
            }
            sb.append(columnName.get(i).getName());
            sb.append(i == columnCount - 1 && upperKey.isIncluded() ? "<=" : "<");
            sb.append(mysqlSqlBuilder.getSqlString(upperKey.getPrimaryKeyColumn(i)));
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getPkCondition(List<ColumnMeta> columns, PrimaryKey key, SqlUtils.ExprCondition expr) {
        List<Column> values = key.getPrimaryKeyColumns();
        int columnCount = values.size();
        StringBuilder condition = new StringBuilder();
        condition.append("(");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                condition.append(" OR ");
            }
            condition.append("(");
            for (int j = 0; j < i; ++j) {
                if (j > 0) {
                    condition.append(" and ");
                }
                condition.append(columns.get(j).getName());
                condition.append("=");
                condition.append(mysqlSqlBuilder.getSqlString(values.get(j)));
            }
            if (i > 0) {
                condition.append(" AND ");
            }
            condition.append(columns.get(i).getName());
            switch (expr) {
                case LESS_THAN: {
                    if (key.isIncluded()) {
                        condition.append(" <= ");
                        break;
                    }
                    condition.append(" < ");
                    break;
                }
                case GREATER_THAN: {
                    if (key.isIncluded()) {
                        condition.append(" >= ");
                        break;
                    }
                    condition.append(" > ");
                    break;
                }
                case EQUAL: {
                    condition.append(" = ");
                }
            }
            condition.append(mysqlSqlBuilder.getSqlString(values.get(i)));
            condition.append(")");
        }
        condition.append(")");
        return condition.toString();
    }
}

