/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core;

import com.oceanbase.tools.migrator.common.configure.LogicTableConfig;
import com.oceanbase.tools.migrator.common.dto.HistoryJob;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.JobType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.TableMetaInitException;
import com.oceanbase.tools.migrator.common.meta.TableMetaManager;
import com.oceanbase.tools.migrator.core.JobReq;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceFactory;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMetaFactory {
    private static final Logger log = LoggerFactory.getLogger(JobMetaFactory.class);

    public static JobMeta create(JobReq jobReq) throws Exception {
        try {
            HistoryJob historyJob = jobReq.getHistoryJob();
            JobMeta jobMeta = new JobMeta();
            jobMeta.setJobId(historyJob.getId());
            jobMeta.setJobType(historyJob.getJobType());
            jobMeta.setNeedPrintSqlTrace(historyJob.getPrintSqlTrace());
            jobMeta.setDateStart(historyJob.getDateStart());
            jobMeta.setDateEnd(historyJob.getDateEnd());
            jobMeta.setJobParameter(historyJob.getJobParameter());
            jobMeta.setLogicTableConfig(jobReq.getLogicTableConfig());
            jobMeta.setTargetCluster(jobReq.getTargetCluster());
            jobMeta.setSourceCluster(jobReq.getSourceCluster());
            jobMeta.setSourceTenant(jobReq.getSourceTenant());
            jobMeta.setTargetTenant(jobReq.getTargetTenant());
            jobMeta.setSourceAdapter(DataSourceFactory.getDataSource(jobReq.getSourceDs()));
            jobMeta.setTargetAdapter(DataSourceFactory.getDataSource(jobReq.getTargetDs()));
            JobMetaFactory.initTableMeta(jobMeta, historyJob.getSourceTable(), historyJob.getTargetTable(), historyJob.getTableId());
            log.info("set primary table meta use source table meta");
            jobMeta.setPrimaryTableMeta(jobMeta.getSourceTableMeta());
            if (JobMetaFactory.needDateCondition(jobMeta)) {
                JobMetaFactory.genDateConditionExpr(jobMeta);
            }
            int threadCount = 1 + jobMeta.getLogicTableConfig().getReaderTaskCount() + jobMeta.getLogicTableConfig().getWriterTaskCount();
            if (historyJob.getJobType() == JobType.DELETE) {
                threadCount += jobMeta.getReaderTaskCount();
            }
            jobMeta.setExecutorService(Executors.newFixedThreadPool(threadCount));
            return jobMeta;
        }
        catch (Exception e) {
            log.warn("Create job meta failed,error=", (Throwable)e);
            throw e;
        }
    }

    private static void genDateConditionExpr(JobMeta jobMeta) throws DefinedException {
        String expr;
        switch (jobMeta.getSourceAdapter().getDataBaseType()) {
            case OB_MYSQL: 
            case MYSQL: 
            case OB_ORACLE: {
                expr = JobMetaFactory.genObDateConditionExpr(jobMeta);
                break;
            }
            case ORACLE: {
                expr = JobMetaFactory.getOracleDateConditionExpr(jobMeta);
                break;
            }
            default: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this datasource type: " + jobMeta.getSourceAdapter().getDataBaseType().name());
            }
        }
        jobMeta.setDateConditionExpr(expr);
    }

    private static String genObDateConditionExpr(JobMeta jobMeta) throws DefinedException {
        String expr = null;
        LogicTableConfig logicTableConfig = jobMeta.getLogicTableConfig();
        if (logicTableConfig.getMigrateDateFormat() != null && logicTableConfig.getMigrateDateColumn() != null) {
            expr = String.format("%s >= '%s' AND %s < '%s'", logicTableConfig.getMigrateDateColumn(), SqlUtils.formatDateString(jobMeta.getDateStart(), logicTableConfig.getMigrateDateFormat()), logicTableConfig.getMigrateDateColumn(), SqlUtils.formatDateString(jobMeta.getDateEnd(), logicTableConfig.getMigrateDateFormat()));
        }
        return expr;
    }

    private static String getOracleDateConditionExpr(JobMeta jobMeta) {
        String expr = null;
        LogicTableConfig logicTableConfig = jobMeta.getLogicTableConfig();
        if (logicTableConfig.getMigrateDateFormat() != null && logicTableConfig.getMigrateDateColumn() != null) {
            DataType dataType = DataType.UNKNOWN;
            if (jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn()) != null) {
                dataType = jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn()).getType();
            } else if (jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn().toUpperCase()) != null) {
                dataType = jobMeta.getSourceTableMeta().getColumnMeta(logicTableConfig.getMigrateDateColumn().toUpperCase()).getType();
            }
            if (!dataType.equals((Object)DataType.UNKNOWN)) {
                expr = String.format("%s >= %s AND %s < %s", logicTableConfig.getMigrateDateColumn().toUpperCase(), SqlUtils.formatOracleDateString(jobMeta.getDateStart(), logicTableConfig.getMigrateDateFormat(), dataType), logicTableConfig.getMigrateDateColumn().toUpperCase(), SqlUtils.formatOracleDateString(jobMeta.getDateEnd(), logicTableConfig.getMigrateDateFormat(), dataType));
            } else {
                throw new DefinedException(ErrorType.UNEXPECTED_ERROR, String.format("not find date column: [%s]", logicTableConfig.getMigrateDateColumn()));
            }
        }
        return expr;
    }

    private static boolean needDateCondition(JobMeta jobMeta) {
        if (jobMeta.getLogicTableConfig().getMigrateDateColumn() != null && jobMeta.getLogicTableConfig().getMigrateDateFormat() != null) {
            return !JobMetaFactory.isDateColumnPkColumnPrefix(jobMeta);
        }
        return false;
    }

    public static void initTableMeta(JobMeta jobMeta, String srcTable, String targetTable, Long tableId) throws TableMetaInitException {
        try {
            jobMeta.setSourceTableMeta(TableMetaManager.getTableMeta(jobMeta.getSourceAdapter(), srcTable, tableId));
            jobMeta.setTargetTableMeta(TableMetaManager.getTableMeta(jobMeta.getTargetAdapter(), targetTable, tableId));
        }
        catch (SQLException e) {
            throw new TableMetaInitException(jobMeta.getJobId(), e);
        }
    }

    public static boolean isDateColumnPkColumnPrefix(JobMeta jobMeta) {
        return jobMeta.getPrimaryTableMeta().getShardKeyColumns().get(0).getName().equals(jobMeta.getLogicTableConfig().getMigrateDateColumn());
    }
}

