/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import org.apache.commons.lang.StringUtils;

public class MysqlSqlBuilder
extends ObMysqlSqlBuilder {
    @Override
    public String getReadDataSql() {
        return this.format();
    }

    @Override
    public String getSplitSql() {
        return this.format();
    }

    @Override
    protected String format() {
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.getHint());
        builder.append(" ").append(this.getSelectColumns());
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.getTableName()).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (StringUtils.isNotEmpty((String)this.shardKeyName)) {
            builder.append(String.format(" force index(%s) ", this.shardKeyName));
        } else {
            builder.append(" force index(PRIMARY) ");
        }
        if (!this.userDefinedConditions.isEmpty() || !this.primaryKeyConditions.isEmpty()) {
            builder.append(" ").append("WHERE");
        }
        int conditionCount = 0;
        for (String userDefinedCondition : this.userDefinedConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(userDefinedCondition).append(")");
            ++conditionCount;
        }
        for (String primaryKeyCondition : this.primaryKeyConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(primaryKeyCondition).append(")");
            ++conditionCount;
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (int i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            if (this.offset != null) {
                builder.append(" ").append(this.getOffset()).append(" ,");
            }
            builder.append(" ").append(this.getLimit());
        }
        return builder.toString();
    }
}

