/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMysqlSqlBuilder
extends AbstractSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ObMysqlSqlBuilder.class);
    private static Pattern EXTRACT_NUMBER = Pattern.compile("(?<=\\()[^)]+");
    private static Pattern EXTRACT_VARCHAR = Pattern.compile("varchar\\((?<length>\\w+)\\)");

    protected String format() {
        this.hint = "/*+ READ_CLUSTER(SLAVE), READ_CONSISTENCY(WEAK), NO_REWRITE */";
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.getHint());
        builder.append(" ").append(this.getSelectColumns());
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.getTableName()).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (!this.userDefinedConditions.isEmpty() || !this.primaryKeyConditions.isEmpty()) {
            builder.append(" ").append("WHERE");
        }
        int conditionCount = 0;
        for (String userDefinedCondition : this.userDefinedConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(userDefinedCondition).append(")");
            ++conditionCount;
        }
        for (String primaryKeyCondition : this.primaryKeyConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(primaryKeyCondition).append(")");
            ++conditionCount;
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (int i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            if (this.offset != null) {
                builder.append(" ").append(this.getOffset()).append(" ,");
            }
            builder.append(" ").append(this.getLimit());
        }
        return builder.toString();
    }

    @Override
    public String getIndexSql(String tableName) {
        return String.format("show index from %s", tableName);
    }

    @Override
    public String getDescSql(String tableName, String tableOwner) {
        return String.format("desc `%s`", tableName);
    }

    @Override
    public String getReadDataSql() {
        return this.format();
    }

    @Override
    public String getSplitSql() {
        return this.format();
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                sqlStr = String.format("'%s'", column.getString());
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    private String appendEscapeChar(String stringValue) {
        StringBuilder buffer = new StringBuilder((int)((double)stringValue.length() * 1.1));
        buffer.append("'");
        block8: for (char c : stringValue.toCharArray()) {
            switch (c) {
                case '\u0000': {
                    buffer.append('\\');
                    buffer.append('0');
                    continue block8;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block8;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block8;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block8;
                }
                case '\u001a': {
                    buffer.append('\\');
                    buffer.append('Z');
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append("'");
        return buffer.toString();
    }

    private boolean isEscapeNeededForString(Column column) {
        boolean needsHexEscape = false;
        for (char c : column.getString().toCharArray()) {
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    @Override
    public List<ColumnMeta> extractColumnMetas(ResultSet rs) throws SQLException {
        String extraColumn = "Extra";
        String defaultColumn = "Default";
        String nullableColumn = "Null";
        String fieldColumn = "Field";
        String typeColumn = "Type";
        Pattern VIRTUAL_GENERATED = Pattern.compile("VIRTUAL GENERATED");
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
        while (rs.next()) {
            Matcher varcharMatcher;
            Matcher matcher;
            DataType dataType;
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setColIdx(columnMetas.size());
            columnMeta.setName(rs.getString(fieldColumn));
            columnMeta.setColumnType(rs.getString(typeColumn));
            columnMeta.setNullAble("YES".equals(rs.getString(nullableColumn).toUpperCase()));
            columnMeta.setExtra(rs.getString(extraColumn));
            columnMeta.setDefaultValue("NULL".equals(rs.getString(defaultColumn)) ? null : rs.getString(defaultColumn));
            Pattern virtualGenPattern = VIRTUAL_GENERATED;
            Matcher virtualGenMatcher = virtualGenPattern.matcher(columnMeta.getExtra());
            if (virtualGenMatcher.find()) continue;
            String typeLower = columnMeta.getColumnType().toLowerCase();
            if (typeLower.contains("int")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("char")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("varchar")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("text")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("numeric")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("decimal")) {
                dataType = DataType.DECIMAL;
            } else if (typeLower.contains("date") || typeLower.contains("year")) {
                dataType = DataType.DATE;
            } else if (typeLower.contains("time")) {
                dataType = DataType.TIME;
            } else if (typeLower.contains("datetime")) {
                dataType = DataType.DATETIME;
            } else if (typeLower.contains("timestamp")) {
                dataType = DataType.TIMESTAMP;
            } else if (typeLower.contains("binary") || typeLower.contains("blob")) {
                dataType = DataType.BYTES;
            } else if (typeLower.contains("double")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("float")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("json")) {
                dataType = DataType.JSON;
            } else {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type: " + typeLower);
            }
            columnMeta.setType(dataType);
            if ((dataType == DataType.NUMBER || dataType == DataType.DECIMAL || dataType == DataType.DOUBLE) && (matcher = EXTRACT_NUMBER.matcher(columnMeta.getColumnType())).find()) {
                if (matcher.group().contains(",")) {
                    String[] nums = matcher.group().split(",");
                    columnMeta.setPrecision(Integer.valueOf(nums[0]));
                    columnMeta.setScope(Integer.valueOf(nums[1]));
                } else {
                    columnMeta.setPrecision(Integer.valueOf(matcher.group()));
                    columnMeta.setScope(0);
                }
            }
            if (dataType == DataType.STRING && (varcharMatcher = EXTRACT_VARCHAR.matcher(columnMeta.getColumnType())).matches()) {
                int dataLength = Integer.valueOf(varcharMatcher.group("length"));
                columnMeta.setDataLength(dataLength);
            }
            columnMetas.add(columnMeta);
        }
        return columnMetas;
    }

    @Override
    public String getShardKeySql(String tableName, String schemaName) {
        return String.format("SELECT INDEX_NAME,GROUP_CONCAT(COLUMN_NAME ORDER BY SEQ_IN_INDEX SEPARATOR ',') AS UK_INDEX_COLUMNS FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND NON_UNIQUE = 0 AND NULLABLE != 'YES' GROUP BY INDEX_NAME", tableName, schemaName);
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM `%s` WHERE ", tableMeta.getName(), tableMeta.getShardKeyName(), tableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getSingleGetCondition(tableMeta.getShardKeyColumns(), tableMeta.getDataBaseType());
        return deleteSql;
    }

    @Override
    public String getBatchDeleteSql(TableMeta tableMeta, int batchSize) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM `%s` WHERE ", tableMeta.getName(), tableMeta.getShardKeyName(), tableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getMultiGetCondition(tableMeta.getShardKeyColumns(), batchSize, tableMeta.getDataBaseType());
        return deleteSql;
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta, String part, String condition, int batchSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM `").append(tableMeta.getName()).append("`");
        if (StringUtils.isNotEmpty((String)part)) {
            sb.append(" PARTITION(").append(part).append(")");
        }
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" WHERE ").append(condition);
        }
        sb.append(" LIMIT ").append(batchSize);
        return sb.toString();
    }
}

