/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleSqlBuilder
extends OracleSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ObOracleSqlBuilder.class);

    @Override
    public String format() {
        int i;
        boolean needSubQuery;
        this.hint = "/*+ READ_CLUSTER(SLAVE), READ_CONSISTENCY(WEAK), NO_REWRITE, QUERY_TIMEOUT(30000000) */";
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0 || this.tableOwner.length() <= 0) {
            throw new UnExpectedException("columnList, tableOwner, tableName cat not be null");
        }
        StringBuilder builder = new StringBuilder();
        boolean bl = needSubQuery = this.userDefinedConditions.size() > 0;
        if (this.offset != null) {
            builder.append("SELECT ").append(this.getSelectColumns()).append(" FROM (");
            builder.append("SELECT ").append(this.getSelectColumns()).append(", ROWNUM RE FROM (");
        }
        if (needSubQuery) {
            builder.append("SELECT ").append(this.getSelectColumns());
            builder.append(" FROM (");
        }
        builder.append("SELECT");
        if (this.hint.length() > 0) {
            builder.append(" ").append(this.getHint());
        }
        builder.append(" ").append(this.getSelectColumns());
        builder.append(" FROM \"");
        builder.append(this.getTableOwner().toUpperCase());
        builder.append("\".\"");
        builder.append(this.getTableName().toUpperCase()).append("\"");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (this.primaryKeyConditions.size() > 0) {
            builder.append(" ").append("WHERE");
            for (i = 0; i < this.primaryKeyConditions.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.primaryKeyConditions.get(i)).append(")");
            }
        }
        if (needSubQuery) {
            builder.append(" )");
            builder.append(" WHERE");
            for (i = 0; i < this.userDefinedConditions.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.userDefinedConditions.get(i)).append(")");
            }
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(SqlUtils.quoteOracleIdentifier(((ColumnMeta)this.orderByColumns.get(i)).getName())).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.offset != null) {
            builder.append(")");
            builder.append("WHERE ROWNUM <= ").append(this.offset);
            builder.append(") WHERE RE = ").append(this.offset);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolvePkColumn(Connection connection, String tableName, List<ColumnMeta> columnMetas, String tableOwner) {
        block7: {
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                String getOracleModePKSql = String.format("SELECT A.COLUMN_NAME COLUMN_NAME,A.ROWKEY_POSITION POSITION FROM SYS.ALL_VIRTUAL_COLUMN_AGENT  A, SYS.ALL_VIRTUAL_TABLE_AGENT B, SYS.ALL_VIRTUAL_DATABASE_AGENT C WHERE A.ROWKEY_POSITION > 0 AND A.TABLE_ID =B.TABLE_ID AND B.DATABASE_ID = C.DATABASE_ID AND B.TABLE_NAME=UPPER('%s') AND C.DATABASE_NAME = UPPER('%s')", tableName, tableOwner);
                log.debug(String.format("execute resolve OceanBase Oracle mode PK, %s", getOracleModePKSql));
                rs = statement.executeQuery(getOracleModePKSql);
                while (rs.next()) {
                    for (ColumnMeta columnMeta : columnMetas) {
                        if (!columnMeta.getName().equalsIgnoreCase(rs.getString("COLUMN_NAME"))) continue;
                        columnMeta.setShardKeyIndex(rs.getInt("POSITION") - 1);
                    }
                }
                DbUtils.closeQuietly(rs);
            }
            catch (SQLException e) {
                log.warn("fail to resolve Oracle PK column", (Throwable)e);
                break block7;
            }
            finally {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(statement);
            }
            DbUtils.closeQuietly(statement);
        }
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: 
            case TIMESTAMP: {
                sqlStr = String.format("'%s'", column.getString());
                break;
            }
            case ORACLE_DATE: {
                sqlStr = String.format("TO_DATE('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss");
                break;
            }
            case ORACLE_TIMESTAMP: {
                sqlStr = String.format("TO_TIMESTAMP('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss.ff");
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    @Override
    public String getShardKeySql(String schemaName, String tableName) {
        return String.format("SELECT cons.constraint_name AS INDEX_NAME,listagg(cols.column_name, ',') WITHIN GROUP (ORDER BY cols.position) AS UK_INDEX_COLUMNS FROM all_cons_columns cols JOIN all_constraints cons ON cons.constraint_name = cols.constraint_name AND cons.owner = cols.owner WHERE cons.constraint_type = 'P' AND cols.table_name = '%s' AND cons.owner = '%s' GROUP BY cons.constraint_name;", tableName, schemaName);
    }
}

