/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSqlBuilder
extends AbstractSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(OracleSqlBuilder.class);
    protected String tableOwner = "";

    @Override
    public String getDeleteSql(TableMeta tableMeta) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM \"%s\" WHERE ", tableMeta.getName(), tableMeta.getShardKeyName(), tableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getSingleGetCondition(tableMeta.getShardKeyColumns(), tableMeta.getDataBaseType());
        return deleteSql;
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta, String part, String condition, int batchSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(SqlUtils.quoteOracleIdentifier(tableMeta.getName()));
        sb.append(" WHERE ROWID IN(SELECT ROWID FROM ").append(SqlUtils.quoteOracleIdentifier(tableMeta.getName()));
        sb.append(" WHERE ROWNUM <= ").append(batchSize);
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" AND ").append(condition);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getBatchDeleteSql(TableMeta tableMeta, int batchSize) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM %s WHERE ", SqlUtils.quoteOracleIdentifier(tableMeta.getName()), tableMeta.getShardKeyName(), tableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getMultiGetCondition(tableMeta.getShardKeyColumns(), batchSize, DataBaseType.ORACLE);
        return deleteSql;
    }

    public String format() {
        int i;
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0 || this.tableOwner.length() <= 0) {
            throw new UnExpectedException("columnList, tableOwner, tableName cat not be null");
        }
        StringBuilder builder = new StringBuilder();
        if (this.offset != null) {
            builder.append("SELECT");
            builder.append(" ").append(this.getSelectColumns());
            builder.append(" FROM").append(" (");
            this.batchSize = this.offset;
        }
        builder.append("SELECT");
        builder.append(" ").append(this.getSelectColumns());
        if (this.offset != null) {
            builder.append(" ,T1.RECON");
        }
        builder.append(" FROM").append(" (");
        builder.append("SELECT");
        builder.append(" ").append("ROWNUM AS RECON, ").append(" ");
        builder.append(this.getSelectColumns());
        builder.append(" ").append("FROM");
        builder.append(" ").append("(");
        builder.append("SELECT");
        if (this.hint.length() > 0) {
            builder.append(" ").append(this.getHint());
        }
        builder.append(" ").append(this.getSelectColumns());
        builder.append(" FROM ");
        builder.append(SqlUtils.quoteOracleIdentifier(this.getTableOwner().toUpperCase()));
        builder.append(".");
        builder.append(SqlUtils.quoteOracleIdentifier(this.getTableName().toUpperCase()));
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        builder.append(" T ");
        if (this.primaryKeyConditions.size() > 0) {
            builder.append(" ").append("WHERE");
            for (i = 0; i < this.primaryKeyConditions.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.primaryKeyConditions.get(i)).append(")");
            }
        } else if (this.minPrimaryKeyLowCond.size() > 0) {
            builder.append(" ").append("WHERE");
            for (i = 0; i < this.minPrimaryKeyLowCond.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.minPrimaryKeyLowCond.get(i)).append(")");
            }
        }
        if (this.userDefinedConditions.size() > 0) {
            if (this.primaryKeyConditions.size() == 0 && this.minPrimaryKeyLowCond.size() == 0) {
                builder.append(" ").append("WHERE");
            }
            for (i = 0; i < this.userDefinedConditions.size(); ++i) {
                if (this.primaryKeyConditions.size() > 0 || this.minPrimaryKeyLowCond.size() > 0 || i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.userDefinedConditions.get(i)).append(")");
            }
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        builder.append(" )").append(" WHERE");
        builder.append(" ").append("ROWNUM").append(" <= ").append(this.getBatchSize()).append(" ) T1");
        if (this.maxPrimaryKeyLowCond.size() > 0) {
            builder.append(" WHERE ");
            for (i = 0; i < this.maxPrimaryKeyLowCond.size(); ++i) {
                if (i > 0) {
                    builder.append(" ").append("AND");
                }
                builder.append(" (").append((String)this.maxPrimaryKeyLowCond.get(i)).append(")");
            }
        }
        if (this.offset != null) {
            builder.append(" )").append("WHERE");
            builder.append(" ").append("RECON").append(" = ").append(this.getOffset());
        }
        return builder.toString();
    }

    @Override
    public String getIndexSql(String tableName) {
        return String.format("SELECT case when t2.CONSTRAINT_TYPE = 'P' then 'PRIMARY' else t2.CONSTRAINT_TYPE end \"Key_name\",t1.COLUMN_NAME \"Column_name\",t1.POSITION \"Seq_in_index\" FROM DBA_CONS_COLUMNS t1, DBA_CONSTRAINTS t2 WHERE t1.CONSTRAINT_NAME = t2.CONSTRAINT_NAME and t2.OWNER = upper('%s') AND t2.TABLE_NAME = '%s'", this.tableOwner, tableName);
    }

    @Override
    public String getDescSql(String tableName, String tableOwner) {
        return String.format("SELECT COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_SCALE,NULLABLE,DATA_DEFAULT FROM DBA_TAB_COLUMNS WHERE OWNER = '%s' AND TABLE_NAME LIKE '%s' ORDER BY COLUMN_ID", tableOwner.toUpperCase(), tableName.toUpperCase());
    }

    @Override
    public String getReadDataSql() {
        return this.format();
    }

    @Override
    public String getSplitSql() {
        return this.format();
    }

    @Override
    public String getTableOwner() {
        return this.tableOwner;
    }

    @Override
    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    @Override
    public void addMinPrimaryKeyCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.minPrimaryKeyLowCond.add(condition);
        }
    }

    @Override
    public void addMaxPrimaryKeyCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.maxPrimaryKeyLowCond.add(condition);
        }
    }

    @Override
    public void setOrderByColumns(List<ColumnMeta> orderByColumns) {
        this.orderByColumns = orderByColumns;
    }

    public String toString() {
        return this.format();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolvePkColumn(Connection connection, String tableName, List<ColumnMeta> columnMetas, String tableOwner) {
        block10: {
            String oraclePkColumn = "COLUMN_NAME";
            String oraclePKPosition = "POSITION";
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                String getOraclePKSql = String.format("SELECT COLUMN_NAME,POSITION FROM DBA_CONS_COLUMNS WHERE CONSTRAINT_NAME = (SELECT CONSTRAINT_NAME FROM DBA_CONSTRAINTS WHERE OWNER = '%s' AND TABLE_NAME = '%s' AND CONSTRAINT_TYPE = 'P') ", tableOwner.toUpperCase(), tableName.toUpperCase());
                log.debug(String.format("execute resolve Oracle PK, %s", getOraclePKSql));
                rs = statement.executeQuery(getOraclePKSql);
                boolean hasPK = false;
                while (rs.next()) {
                    hasPK = true;
                    for (ColumnMeta columnMeta : columnMetas) {
                        if (!columnMeta.getName().equalsIgnoreCase(rs.getString(oraclePkColumn))) continue;
                        columnMeta.setShardKeyIndex(Integer.parseInt(rs.getString(oraclePKPosition)) - 1);
                    }
                }
                if (!hasPK) {
                    String getOracleUkSql = String.format("SELECT COLUMN_NAME,COLUMN_POSITION FROM DBA_IND_COLUMNS WHERE INDEX_NAME = (SELECT INDEX_NAME FROM DBA_INDEXES WHERE OWNER = '%s' AND TABLE_OWNER = '%s' AND TABLE_NAME = '%s' AND UNIQUENESS='UNIQUE' and ROWNUM <2)", tableOwner.toUpperCase(), tableOwner.toUpperCase(), tableName.toUpperCase());
                    rs = statement.executeQuery(getOracleUkSql);
                    while (rs.next()) {
                        for (ColumnMeta columnMeta : columnMetas) {
                            if (!columnMeta.getName().equalsIgnoreCase(rs.getString(1))) continue;
                            columnMeta.setShardKeyIndex(Integer.parseInt(rs.getString(2)) - 1);
                        }
                    }
                }
                DbUtils.closeQuietly(rs);
            }
            catch (SQLException e) {
                log.warn("fail to resolve Oracle PK column", (Throwable)e);
                break block10;
            }
            finally {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(statement);
            }
            DbUtils.closeQuietly(statement);
        }
    }

    @Override
    public List<ColumnMeta> extractColumnMetas(ResultSet rs) throws SQLException {
        String oracleFieldColumn = "COLUMN_NAME";
        String oracleTypeColumn = "DATA_TYPE";
        String oracleDataLengthColumn = "DATA_LENGTH";
        String oracleDataScaleColumn = "DATA_SCALE";
        String oracleNullAbleColumn = "NULLABLE";
        String oracleDefaultColumn = "DATA_DEFAULT";
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(10);
        while (rs.next()) {
            DataType dataType;
            ColumnMeta columnMeta = new ColumnMeta();
            if (rs == null) continue;
            columnMeta.setColIdx(columnMetas.size());
            columnMeta.setName(rs.getString(oracleFieldColumn));
            columnMeta.setColumnType(rs.getString(oracleTypeColumn));
            columnMeta.setDataLength(rs.getInt(oracleDataLengthColumn));
            columnMeta.setNullAble("Y".equals(rs.getString(oracleNullAbleColumn)));
            columnMeta.setDefaultValue(rs.getString(oracleDefaultColumn));
            String typeLower = columnMeta.getColumnType().toLowerCase();
            if (typeLower.contains("int")) {
                dataType = DataType.NUMBER;
            } else if (typeLower.contains("char")) {
                dataType = DataType.STRING;
            } else if (typeLower.contains("decimal")) {
                dataType = DataType.DECIMAL;
            } else if (typeLower.contains("number")) {
                dataType = rs.getInt(oracleDataScaleColumn) > 0 ? DataType.DECIMAL : DataType.NUMBER;
            } else if (typeLower.contains("date")) {
                dataType = DataType.ORACLE_DATE;
            } else if (typeLower.contains("timestamp")) {
                dataType = DataType.ORACLE_TIMESTAMP;
            } else if (typeLower.contains("double")) {
                dataType = DataType.DOUBLE;
            } else if (typeLower.contains("clob")) {
                dataType = DataType.STRING;
            } else {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type: " + typeLower);
            }
            if (dataType == DataType.DECIMAL) {
                columnMeta.setPrecision(rs.getInt(oracleDataLengthColumn));
                columnMeta.setScope(rs.getInt(oracleDataScaleColumn));
            }
            columnMeta.setType(dataType);
            columnMetas.add(columnMeta);
        }
        return columnMetas;
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: {
                sqlStr = String.format("TO_DATE('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss");
                break;
            }
            case TIMESTAMP: {
                sqlStr = String.format("TO_TIMESTAMP('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss.ff");
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    @Override
    public String getShardKeySql(String tableName, String schemaName) {
        return null;
    }

    protected String appendEscapeChar(String stringValue) {
        StringBuilder buffer = new StringBuilder((int)((double)stringValue.length() * 1.1));
        buffer.append("'");
        block8: for (char c : stringValue.toCharArray()) {
            switch (c) {
                case '\u0000': {
                    buffer.append('\\');
                    buffer.append('0');
                    continue block8;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block8;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block8;
                }
                case '\'': {
                    buffer.append('\'');
                    buffer.append('\'');
                    continue block8;
                }
                case '\u001a': {
                    buffer.append('\\');
                    buffer.append('Z');
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append("'");
        return buffer.toString();
    }

    protected boolean isEscapeNeededForString(Column column) {
        boolean needsHexEscape = false;
        for (char c : column.getString().toCharArray()) {
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }
}

