/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.MysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.ObOracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(SqlBuilderFactory.class);

    public static AbstractSqlBuilder getSqlBuilder(DataBaseType dataBaseType) {
        AbstractSqlBuilder abstractSqlBuilder = null;
        switch (dataBaseType) {
            case OB_MYSQL: {
                abstractSqlBuilder = new ObMysqlSqlBuilder();
                break;
            }
            case MYSQL: {
                abstractSqlBuilder = new MysqlSqlBuilder();
                break;
            }
            case ORACLE: {
                abstractSqlBuilder = new OracleSqlBuilder();
                break;
            }
            case OB_ORACLE: {
                abstractSqlBuilder = new ObOracleSqlBuilder();
                break;
            }
            default: {
                log.warn(String.format("not support database type : [%s] at get sql builder", dataBaseType.toString()));
                throw new DefinedException(ErrorType.INVALID_DATABASE_TYPE, String.format("not support database type : [%s] at get sql builder", dataBaseType.toString()));
            }
        }
        return abstractSqlBuilder;
    }
}

