/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.handler.IHandler;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractHandler
implements IHandler {
    protected DataSourceAdapter dataSourceAdapter = null;

    public AbstractHandler(DataSourceAdapter dataSourceAdapter) {
        this.dataSourceAdapter = dataSourceAdapter;
    }

    @Override
    public Object run() throws SQLException {
        Object retObj = null;
        if (this.dataSourceAdapter == null) {
            throw new IllegalArgumentException("invalid data source adapter");
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            retObj = this.run(connection);
        }
        finally {
            DbUtils.closeQuietly(connection);
        }
        return retObj;
    }

    public abstract Connection getConnection() throws SQLException;

    public abstract Object run(Connection var1) throws SQLException;
}

