/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.IDataWriteHandler;
import com.oceanbase.tools.migrator.core.handler.MySQLDataWriterHandler;
import com.oceanbase.tools.migrator.core.handler.OracleDataWriteHandler;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DataWriteHandler {
    private static final Map<DataBaseType, IDataWriteHandler> dataWriteHandlerMap = new HashMap<DataBaseType, IDataWriteHandler>();

    public static void write(TransRows rows) throws SQLException {
        DataWriteHandler.getDataWriteHandler(rows.getOwnerTaskMeta().getJobMeta().getTargetAdapter().getDataBaseType()).write(rows);
    }

    private static IDataWriteHandler getDataWriteHandler(DataBaseType dbType) {
        IDataWriteHandler handler = dataWriteHandlerMap.get((Object)dbType);
        if (handler == null) {
            if (dbType.isOracle()) {
                dataWriteHandlerMap.put(dbType, new OracleDataWriteHandler());
            }
            if (dbType.isMySQL()) {
                dataWriteHandlerMap.put(dbType, new MySQLDataWriterHandler());
            }
        }
        return dataWriteHandlerMap.get((Object)dbType);
    }
}

