/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.DbUtils;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.handler.HandlerUtils;
import com.oceanbase.tools.migrator.core.handler.IDataWriteHandler;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDataWriteHandler
implements IDataWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(OracleDataWriteHandler.class);
    private static final int DUPLICATE_ENTRY_CODE = 1;

    @Override
    public void write(TransRows rows) throws SQLException {
        if (rows.getRowCount() == 0) {
            return;
        }
        DataSourceAdapter targetDs = rows.getOwnerTaskMeta().getJobMeta().getTargetAdapter();
        HandlerUtils.runWithRetry(() -> {
            for (int i = rows.getBatchRowsCount() - 1; i >= 0; --i) {
                this.writeBatchRows(targetDs, rows.getBatchRows(i));
            }
            return null;
        });
    }

    private void writeBatchRows(DataSourceAdapter dataSourceAdapter, BatchRows batchRows) throws SQLException {
        Map<Long, BatchRows> batchRowsMap = HandlerUtils.groupBatchRowByPartition(batchRows);
        MigrationInsertAction insertAction = batchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta().getLogicTableConfig().getMigrationInsertAction();
        for (BatchRows groupedBatchRows : batchRowsMap.values()) {
            if (insertAction == MigrationInsertAction.INSERT_DUPLICATE_UPDATE) {
                OracleDataWriteHandler.writeBatchRowsByDuplicateUpdate(dataSourceAdapter, groupedBatchRows, batchRows.getOwnerTransRows().getOwnerTaskMeta());
                continue;
            }
            this.writeBatchRows(dataSourceAdapter, groupedBatchRows, batchRows.getOwnerTransRows().getOwnerTaskMeta(), insertAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBatchRows(DataSourceAdapter dataSourceAdapter, BatchRows batchRows, TaskMeta taskMeta, MigrationInsertAction insertAction) throws SQLException {
        String writeSql = "INSERT INTO %s (%s) VALUES %s";
        TableMeta phyTableMeta = taskMeta.getJobMeta().getTargetTableMeta(batchRows.getTableMeta().getName());
        String columnList = SqlUtils.getColumnListString(batchRows.getTableMeta());
        String columnRefList = SqlUtils.getColumnRefList(batchRows.getTableMeta().getColumnMetas().size());
        writeSql = String.format(writeSql, SqlUtils.quoteIdentifier(phyTableMeta.getName(), phyTableMeta.getDataBaseType()), columnList, columnRefList);
        if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
            log.info("getBatchWriteSql = " + writeSql);
        }
        if (batchRows.getRowCount() > 0) {
            log.debug("{}: {} Write {} Rows.", new Object[]{dataSourceAdapter.getDataSourceInfo().getDataSourceName(), batchRows.getTableMeta().getName(), batchRows.getRowCount()});
        }
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        int writeBatchSize = taskMeta.getJobMeta().getWriterBatchSize();
        boolean needSingleInsert = false;
        List<Row> rows = batchRows.getRows();
        if (rows.isEmpty()) {
            return;
        }
        try {
            connection = dataSourceAdapter.getConnectionForWrite(writeSql);
            preparedStatement = connection.prepareStatement(writeSql);
            for (int i = 0; i < rows.size(); ++i) {
                SqlUtils.setPreparedStatement(preparedStatement, rows.get(i));
                preparedStatement.addBatch();
                if ((i + 1) % writeBatchSize != 0 && i != rows.size() - 1) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            block19: {
                try {
                    if (e.getErrorCode() == 1 && insertAction == MigrationInsertAction.INSERT_IGNORE) {
                        needSingleInsert = true;
                        if (preparedStatement != null) {
                            preparedStatement.clearBatch();
                        }
                        break block19;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(preparedStatement);
                    DbUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(preparedStatement);
            DbUtils.closeQuietly(connection);
        }
        DbUtils.closeQuietly(preparedStatement);
        DbUtils.closeQuietly(connection);
        if (needSingleInsert) {
            try {
                connection = dataSourceAdapter.getConnectionForWrite();
                preparedStatement = connection.prepareStatement(writeSql);
                int singleInsertTotal = rows.size();
                int singleInsertDuplicate = 0;
                for (Row row : rows) {
                    SqlUtils.setPreparedStatement(preparedStatement, row);
                    try {
                        preparedStatement.execute();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1) {
                            if (taskMeta.getJobMeta().getNeedPrintSqlTrace().booleanValue()) {
                                log.info(String.format("Duplicate Key Found Table[%s], PrimKey[%s]", batchRows.getTableMeta().getName(), row.getPrimaryKey()));
                            }
                            taskMeta.getJobMeta().getJobStat().addUnMatchedRowCount(1L);
                            ++singleInsertDuplicate;
                            continue;
                        }
                        throw e;
                    }
                }
                log.info(String.format("Try SingleInsert %d lines, Duplicate Key[%d]", singleInsertTotal, singleInsertDuplicate));
            }
            finally {
                DbUtils.closeQuietly(preparedStatement);
                DbUtils.closeQuietly(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBatchRowsByDuplicateUpdate(DataSourceAdapter dataSourceAdapter, BatchRows batchRows, TaskMeta taskMeta) throws SQLException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        int writeBatchSize = taskMeta.getJobMeta().getWriterBatchSize();
        List<Row> rows = batchRows.getRows();
        String writeSql = OracleDataWriteHandler.getWritUpdateModeSql(taskMeta);
        try {
            connection = dataSourceAdapter.getConnectionForWrite();
            preparedStatement = connection.prepareStatement(writeSql);
            for (int i = 0; i < rows.size(); ++i) {
                SqlUtils.setPreparedStatement(preparedStatement, rows.get(i));
                preparedStatement.addBatch();
                if ((i + 1) % writeBatchSize != 0 && i != rows.size() - 1) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                connection = dataSourceAdapter.getConnectionForWrite();
                preparedStatement = connection.prepareStatement(writeSql);
                for (Row row : rows) {
                    SqlUtils.setPreparedStatement(preparedStatement, row);
                    preparedStatement.execute();
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(preparedStatement);
                DbUtils.closeQuietly(connection);
                throw throwable;
            }
            DbUtils.closeQuietly(preparedStatement);
            DbUtils.closeQuietly(connection);
        }
        DbUtils.closeQuietly(preparedStatement);
        DbUtils.closeQuietly(connection);
    }

    private static String getWritUpdateModeSql(TaskMeta taskMeta) throws SQLException {
        int i;
        TableMeta phyTableMeta = taskMeta.getJobMeta().getTargetTableMeta();
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO ").append(phyTableMeta.getName()).append(" t ").append("USING (SELECT ");
        for (i = 0; i < phyTableMeta.getColumnMetas().size(); ++i) {
            sb.append("? AS ").append(phyTableMeta.getColumnMetas().get(i).getName());
            if (i >= phyTableMeta.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(" FROM DUAL ) s ON (");
        for (i = 0; i < phyTableMeta.getShardKeyColumns().size(); ++i) {
            sb.append(" t.").append(phyTableMeta.getShardKeyColumns().get(i).getName());
            sb.append(" = s.").append(phyTableMeta.getShardKeyColumns().get(i).getName());
            if (i >= phyTableMeta.getShardKeyColumns().size() - 1) continue;
            sb.append(" AND ");
        }
        sb.append(") WHEN MATCHED THEN UPDATE SET ");
        for (i = 0; i < phyTableMeta.getColumnMetas().size(); ++i) {
            if (phyTableMeta.getColumnMetas().get(i).isShardKeyColumn()) continue;
            sb.append(" t.").append(phyTableMeta.getColumnMetas().get(i).getName());
            sb.append(" = s.").append(phyTableMeta.getColumnMetas().get(i).getName());
            if (i >= phyTableMeta.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(" WHEN NOT MATCHED THEN INSERT (");
        for (i = 0; i < phyTableMeta.getColumnMetas().size(); ++i) {
            sb.append(phyTableMeta.getColumnMetas().get(i).getName());
            if (i >= phyTableMeta.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(") ").append("VALUES (");
        for (i = 0; i < phyTableMeta.getColumnMetas().size(); ++i) {
            sb.append("s.").append(phyTableMeta.getColumnMetas().get(i).getName());
            if (i >= phyTableMeta.getColumnMetas().size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

