/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleKeyReadIterator
extends KeyReadIterator {
    private static final Logger log = LoggerFactory.getLogger(OracleKeyReadIterator.class);

    @Override
    public String getMinBoundSql() {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        this.setHintPkName();
        oracleBuilder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        oracleBuilder.setTableOwner(this.dataSourceAdapter.getSchema());
        oracleBuilder.setTableName(this.tableName);
        oracleBuilder.setHint(this.hintPkName);
        oracleBuilder.setPartitionName(this.partitionName);
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(this.tableMeta, this.minKey));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(this.tableMeta, this.maxKey));
        oracleBuilder.setOrderByColumns(this.tableMeta.getShardKeyColumns());
        oracleBuilder.setOrderByMethod(OrderByMethod.ASC);
        oracleBuilder.setOffset(1);
        return oracleBuilder.getSplitSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        this.setHintPkName();
        oracleBuilder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        oracleBuilder.setTableOwner(this.dataSourceAdapter.getSchema());
        oracleBuilder.setTableName(this.tableName);
        oracleBuilder.setHint(this.hintPkName);
        oracleBuilder.setPartitionName(this.partitionName);
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(this.tableMeta, lowerBound));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(this.tableMeta, this.maxKey));
        oracleBuilder.setOrderByColumns(this.tableMeta.getShardKeyColumns());
        oracleBuilder.setOrderByMethod(OrderByMethod.DESC);
        oracleBuilder.setOffset(1);
        return oracleBuilder.getSplitSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        OracleSqlBuilder oracleBuilder = new OracleSqlBuilder();
        this.setHintPkName();
        oracleBuilder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        oracleBuilder.setTableOwner(this.dataSourceAdapter.getSchema());
        oracleBuilder.setTableName(this.tableName);
        oracleBuilder.setHint(this.hintPkName);
        oracleBuilder.setPartitionName(this.partitionName);
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMinkeyCondition(this.tableMeta, lowerBound));
        oracleBuilder.addPrimaryKeyCondition(SqlUtils.getOracleMaxKeyCondition(this.tableMeta, this.maxKey));
        oracleBuilder.setOrderByColumns(this.tableMeta.getShardKeyColumns());
        oracleBuilder.setOrderByMethod(OrderByMethod.ASC);
        oracleBuilder.setOffset(this.batchSize);
        return oracleBuilder.getSplitSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getPrimaryKeyName() throws SQLException {
        String getPrimaryKeyNameSql = "SELECT INDEX_NAME FROM  DBA_CONSTRAINTS WHERE CONSTRAINT_TYPE IN ('P','U') AND TABLE_NAME= ? AND OWNER = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try (Connection connection = this.dataSourceAdapter.getConnectionReadOnly();){
            ps = connection.prepareStatement(getPrimaryKeyNameSql);
            ps.setString(1, this.tableName.toUpperCase());
            ps.setString(2, this.dataSourceAdapter.getSchema().toUpperCase());
            rs = ps.executeQuery();
            if (rs.next()) {
                this.hintPkName = rs.getString(1);
                this.hintPkName = String.format("/*+ index_rs(T %s)*/", this.hintPkName);
            } else {
                log.info(String.format("can't find any index_name use sql:[%s], table_name:[%s], table_owner:[%s]", getPrimaryKeyNameSql, this.tableName.toUpperCase(), this.dataSourceAdapter.getSchema().toUpperCase()));
            }
        }
        catch (SQLException e) {
            try {
                log.warn("filed get index_name cause:", (Throwable)e);
                log.warn("filed get index_name will set primaryket hint empty");
                this.hintPkName = "";
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(ps);
                throw throwable;
            }
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly((Statement)ps);
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)ps);
    }
}

