/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.meta;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.enums.TaskStatus;
import com.oceanbase.tools.migrator.core.data.AbstractData;
import com.oceanbase.tools.migrator.core.data.TransRows;
import com.oceanbase.tools.migrator.core.meta.AbstractMeta;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMeta
extends AbstractMeta {
    private static final Logger log = LoggerFactory.getLogger(TaskMeta.class);
    private static final int PENDING_QUEUE_SIZE = 10;
    private JobMeta jobMeta = null;
    private String generatorId;
    private long taskIndex = 0L;
    private PrimaryKey minPrimaryKey = null;
    private PrimaryKey maxPrimaryKey = null;
    private String partitionName = "";
    private PrimaryKey cursorPrimaryKey = null;
    private TaskStatus taskStatus = TaskStatus.NEW;
    private List<TransRows> pendingTransRows = new LinkedList<TransRows>();
    private ReentrantLock pendingTransRowsLock = new ReentrantLock();
    private Condition notFull = this.pendingTransRowsLock.newCondition();

    public TaskMeta(Map<String, Object> taskEntry, JobMeta jobMeta) {
        String pkCursorStr;
        String pkMaxStr;
        this.taskIndex = (Long)taskEntry.get("task_index");
        String pkMinStr = (String)taskEntry.get("pk_min");
        if (StringUtils.isNotEmpty((String)pkMinStr)) {
            this.minPrimaryKey = PrimaryKey.valuesOf(pkMinStr);
        }
        if (StringUtils.isNotEmpty((String)(pkMaxStr = (String)taskEntry.get("pk_max")))) {
            this.maxPrimaryKey = PrimaryKey.valuesOf(pkMaxStr);
        }
        if (StringUtils.isNotEmpty((String)(pkCursorStr = (String)taskEntry.get("pk_cursor")))) {
            this.cursorPrimaryKey = PrimaryKey.valuesOf(pkCursorStr);
        }
        this.partitionName = (String)taskEntry.get("partition_name");
        this.jobMeta = jobMeta;
    }

    @Override
    public AbstractData getOwner() {
        return this.jobMeta;
    }

    public void checkFinished() {
        if (this.taskStatus.equals((Object)TaskStatus.PRODUCER_FINISHED) && this.pendingTransRows.isEmpty()) {
            this.setTaskStatus(TaskStatus.CONSUMER_FINISHED);
        }
        if (this.taskStatus.equals((Object)TaskStatus.CONSUMER_FINISHED)) {
            this.setTaskStatus(TaskStatus.SUCCESS);
        }
    }

    public void addPendingTransRows(TransRows transRows) throws InterruptedException {
        if (transRows != null) {
            this.pendingTransRowsLock.lock();
            try {
                if (this.pendingTransRows.size() == 10) {
                    this.notFull.await();
                }
                this.pendingTransRows.add(transRows);
            }
            finally {
                this.pendingTransRowsLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishTransRows(TransRows finishedTransRows) {
        if (finishedTransRows != null) {
            finishedTransRows.setFinished(true);
            this.pendingTransRowsLock.lock();
            try {
                TransRows transRows;
                Iterator<TransRows> iterator = this.pendingTransRows.iterator();
                PrimaryKey cursorKey = null;
                boolean removed = false;
                while (iterator.hasNext() && (transRows = iterator.next()).isFinished()) {
                    cursorKey = transRows.getCursorKey();
                    iterator.remove();
                    removed = true;
                }
                if (cursorKey != null) {
                    this.setCursorPrimaryKey(cursorKey);
                }
                if (removed) {
                    this.notFull.signal();
                }
            }
            finally {
                this.pendingTransRowsLock.unlock();
            }
            this.getJobMeta().getJobStat().addDataSize(finishedTransRows.getDataSize());
            this.getJobMeta().getJobStat().addRowCount(finishedTransRows.getRowCount());
            this.getJobMeta().getJobStat().addReadRowCount(finishedTransRows.getReadRowCount());
        }
    }

    @Override
    public void setError(ErrorType errorType, String errMsg) {
        log.warn(String.format("task failed, taskId = [%d], jobId = [%s], errorType = [%s],errorMsg = [%s]", new Object[]{this.taskIndex, this.getJobMeta().getJobId(), errorType, errMsg}));
        this.taskStatus = TaskStatus.FAILED;
        super.setError(errorType, errMsg);
    }

    public String toString() {
        return "TaskMeta(jobMeta=" + this.getJobMeta() + ", generatorId=" + this.getGeneratorId() + ", taskIndex=" + this.getTaskIndex() + ", minPrimaryKey=" + this.getMinPrimaryKey() + ", maxPrimaryKey=" + this.getMaxPrimaryKey() + ", partitionName=" + this.getPartitionName() + ", cursorPrimaryKey=" + this.getCursorPrimaryKey() + ", taskStatus=" + (Object)((Object)this.getTaskStatus()) + ")";
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public String getGeneratorId() {
        return this.generatorId;
    }

    public long getTaskIndex() {
        return this.taskIndex;
    }

    public PrimaryKey getMinPrimaryKey() {
        return this.minPrimaryKey;
    }

    public PrimaryKey getMaxPrimaryKey() {
        return this.maxPrimaryKey;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public PrimaryKey getCursorPrimaryKey() {
        return this.cursorPrimaryKey;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public List<TransRows> getPendingTransRows() {
        return this.pendingTransRows;
    }

    public ReentrantLock getPendingTransRowsLock() {
        return this.pendingTransRowsLock;
    }

    public Condition getNotFull() {
        return this.notFull;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public void setGeneratorId(String generatorId) {
        this.generatorId = generatorId;
    }

    public void setTaskIndex(long taskIndex) {
        this.taskIndex = taskIndex;
    }

    public void setMinPrimaryKey(PrimaryKey minPrimaryKey) {
        this.minPrimaryKey = minPrimaryKey;
    }

    public void setMaxPrimaryKey(PrimaryKey maxPrimaryKey) {
        this.maxPrimaryKey = maxPrimaryKey;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setCursorPrimaryKey(PrimaryKey cursorPrimaryKey) {
        this.cursorPrimaryKey = cursorPrimaryKey;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setPendingTransRows(List<TransRows> pendingTransRows) {
        this.pendingTransRows = pendingTransRows;
    }

    public void setPendingTransRowsLock(ReentrantLock pendingTransRowsLock) {
        this.pendingTransRowsLock = pendingTransRowsLock;
    }

    public void setNotFull(Condition notFull) {
        this.notFull = notFull;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskMeta)) {
            return false;
        }
        TaskMeta other = (TaskMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobMeta this$jobMeta = this.getJobMeta();
        JobMeta other$jobMeta = other.getJobMeta();
        if (this$jobMeta == null ? other$jobMeta != null : !((Object)this$jobMeta).equals(other$jobMeta)) {
            return false;
        }
        String this$generatorId = this.getGeneratorId();
        String other$generatorId = other.getGeneratorId();
        if (this$generatorId == null ? other$generatorId != null : !this$generatorId.equals(other$generatorId)) {
            return false;
        }
        if (this.getTaskIndex() != other.getTaskIndex()) {
            return false;
        }
        PrimaryKey this$minPrimaryKey = this.getMinPrimaryKey();
        PrimaryKey other$minPrimaryKey = other.getMinPrimaryKey();
        if (this$minPrimaryKey == null ? other$minPrimaryKey != null : !this$minPrimaryKey.equals((Object)other$minPrimaryKey)) {
            return false;
        }
        PrimaryKey this$maxPrimaryKey = this.getMaxPrimaryKey();
        PrimaryKey other$maxPrimaryKey = other.getMaxPrimaryKey();
        if (this$maxPrimaryKey == null ? other$maxPrimaryKey != null : !this$maxPrimaryKey.equals((Object)other$maxPrimaryKey)) {
            return false;
        }
        String this$partitionName = this.getPartitionName();
        String other$partitionName = other.getPartitionName();
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        PrimaryKey this$cursorPrimaryKey = this.getCursorPrimaryKey();
        PrimaryKey other$cursorPrimaryKey = other.getCursorPrimaryKey();
        if (this$cursorPrimaryKey == null ? other$cursorPrimaryKey != null : !this$cursorPrimaryKey.equals((Object)other$cursorPrimaryKey)) {
            return false;
        }
        TaskStatus this$taskStatus = this.getTaskStatus();
        TaskStatus other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !((Object)((Object)this$taskStatus)).equals((Object)other$taskStatus)) {
            return false;
        }
        List<TransRows> this$pendingTransRows = this.getPendingTransRows();
        List<TransRows> other$pendingTransRows = other.getPendingTransRows();
        if (this$pendingTransRows == null ? other$pendingTransRows != null : !((Object)this$pendingTransRows).equals(other$pendingTransRows)) {
            return false;
        }
        ReentrantLock this$pendingTransRowsLock = this.getPendingTransRowsLock();
        ReentrantLock other$pendingTransRowsLock = other.getPendingTransRowsLock();
        if (this$pendingTransRowsLock == null ? other$pendingTransRowsLock != null : !this$pendingTransRowsLock.equals(other$pendingTransRowsLock)) {
            return false;
        }
        Condition this$notFull = this.getNotFull();
        Condition other$notFull = other.getNotFull();
        return !(this$notFull == null ? other$notFull != null : !this$notFull.equals(other$notFull));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobMeta $jobMeta = this.getJobMeta();
        result = result * 59 + ($jobMeta == null ? 43 : ((Object)$jobMeta).hashCode());
        String $generatorId = this.getGeneratorId();
        result = result * 59 + ($generatorId == null ? 43 : $generatorId.hashCode());
        long $taskIndex = this.getTaskIndex();
        result = result * 59 + (int)($taskIndex >>> 32 ^ $taskIndex);
        PrimaryKey $minPrimaryKey = this.getMinPrimaryKey();
        result = result * 59 + ($minPrimaryKey == null ? 43 : $minPrimaryKey.hashCode());
        PrimaryKey $maxPrimaryKey = this.getMaxPrimaryKey();
        result = result * 59 + ($maxPrimaryKey == null ? 43 : $maxPrimaryKey.hashCode());
        String $partitionName = this.getPartitionName();
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        PrimaryKey $cursorPrimaryKey = this.getCursorPrimaryKey();
        result = result * 59 + ($cursorPrimaryKey == null ? 43 : $cursorPrimaryKey.hashCode());
        TaskStatus $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : ((Object)((Object)$taskStatus)).hashCode());
        List<TransRows> $pendingTransRows = this.getPendingTransRows();
        result = result * 59 + ($pendingTransRows == null ? 43 : ((Object)$pendingTransRows).hashCode());
        ReentrantLock $pendingTransRowsLock = this.getPendingTransRowsLock();
        result = result * 59 + ($pendingTransRowsLock == null ? 43 : $pendingTransRowsLock.hashCode());
        Condition $notFull = this.getNotFull();
        result = result * 59 + ($notFull == null ? 43 : $notFull.hashCode());
        return result;
    }

    public TaskMeta() {
    }
}

