/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.runner;

import com.oceanbase.tools.migrator.core.handler.DataDeleteHandler;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDataRunner
implements Callable {
    private static final Logger log = LoggerFactory.getLogger(DeleteDataRunner.class);
    private JobMeta jobMeta;
    private String partName;
    private Long deleteCount = 0L;

    public Object call() throws Exception {
        Thread.currentThread().setName("Job-" + this.jobMeta.getJobId() + "-Delete-" + this.partName);
        while (!this.jobMeta.isToStop()) {
            int count = DataDeleteHandler.delete(this.jobMeta.getSourceAdapter(), this.jobMeta.getSourceTableMeta(), this.partName, this.jobMeta.getLogicTableConfig().getMigrateRule(), this.jobMeta.getLogicTableConfig().getDeleteBatchSize());
            this.deleteCount = this.deleteCount + (long)count;
            this.jobMeta.getJobStat().addRowCount(count);
            if (count != 0) continue;
            log.info("delete data finished, partName = {}, count = {}", (Object)this.partName, (Object)this.deleteCount);
            break;
        }
        return null;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }
}

