/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.job;

import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.core.runner.DeleteDataRunner;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.job.AbstractJob;
import com.oceanbase.tools.migrator.partition.PartitionServiceFactory;
import java.util.LinkedList;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDeleteJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(DirectDeleteJob.class);

    @Override
    public void run() throws JobException {
        DataSourceAdapter sourceAdapter = this.jobMeta.getSourceAdapter();
        LinkedList<String> partitionQueue = new LinkedList<String>();
        try {
            partitionQueue.addAll(PartitionServiceFactory.get(sourceAdapter.getDataBaseType()).getAffectedPartitions(this.jobMeta.getSourceAdapter(), this.jobMeta.getSourceTableMeta(), this.jobMeta.getLogicTableConfig().getMigrateRule()));
        }
        catch (Exception e) {
            log.warn("Failed to get partition names, the job will not process data by partition.", (Throwable)e);
            partitionQueue.add("");
        }
        log.info("Start to delete data, partitions: {}", partitionQueue);
        while (!this.jobMeta.isToStop()) {
            while (!partitionQueue.isEmpty() && this.childRunners.size() < this.jobMeta.getLogicTableConfig().getWriterTaskCount()) {
                DeleteDataRunner deleteDataRunner = new DeleteDataRunner();
                deleteDataRunner.setJobMeta(this.jobMeta);
                deleteDataRunner.setPartName((String)partitionQueue.poll());
                this.childRunners.add(this.jobMeta.getExecutorService().submit(deleteDataRunner));
            }
            this.jobMeta.getJobStat().addElapsedTime(10L);
            this.childRunners.removeIf(Future::isDone);
            if (this.childRunners.isEmpty() && partitionQueue.isEmpty()) {
                log.info("All partitions have been cleaned up, and the task is about to exit.");
                break;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            this.jobMeta.reportStatistic();
        }
        for (Future future : this.childRunners) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
        this.jobMeta.reportStatistic();
        this.jobMeta.closeDataAdapter();
        this.jobMeta.destroyExecutor();
    }

    @Override
    void processJobInternal() {
    }

    @Override
    void doTimerTask() {
    }
}

