/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.partition;

import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.partition.IPartitionService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MySQLPartitionService
implements IPartitionService {
    @Override
    public List<String> getAffectedPartitions(DataSourceAdapter datasource, TableMeta tableMeta, String condition) throws SQLException {
        return this.getPartitionNames(datasource, tableMeta);
    }

    @Override
    public List<String> getPartitionNames(DataSourceAdapter datasource, TableMeta tableMeta) throws SQLException {
        LinkedList<String> res = new LinkedList<String>();
        try (Connection conn = datasource.getConnectionReadOnly();){
            PreparedStatement preparedStatement = conn.prepareStatement("select partition_name from `information_schema`.`PARTITIONS` where table_schema = ? and table_name = ? order by PARTITION_ORDINAL_POSITION");
            preparedStatement.setString(1, datasource.getSchema());
            preparedStatement.setString(2, tableMeta.getName());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String pName = resultSet.getString(1);
                if (!StringUtils.isNotEmpty((String)pName)) continue;
                res.add(pName);
            }
        }
        if (res.isEmpty()) {
            res.add("");
        }
        return res;
    }
}

