/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.partition;

import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.partition.IPartitionService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBMySQLPartitionService
implements IPartitionService {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLPartitionService.class);

    @Override
    public List<String> getAffectedPartitions(DataSourceAdapter datasource, TableMeta tableMeta, String condition) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("EXPLAIN PARTITIONS SELECT * FROM ");
        sb.append("`").append(tableMeta.getName()).append("`");
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" WHERE ");
            sb.append(condition);
        }
        List<String> allPartitionNames = this.getPartitionNames(datasource, tableMeta);
        HashSet<String> affectedPartitions = new HashSet<String>();
        try (Connection conn = datasource.getConnectionReadOnly();){
            ResultSet resultSet = conn.prepareStatement(sb.toString()).executeQuery();
            Pattern pattern = Pattern.compile("partitions\\((.*?)\\)");
            while (resultSet.next()) {
                Matcher matcher = pattern.matcher(resultSet.getString(1));
                while (matcher.find()) {
                    affectedPartitions.add(matcher.group(1));
                }
            }
        }
        List<String> result = new LinkedList<String>(allPartitionNames);
        result.retainAll(affectedPartitions);
        if (result.isEmpty()) {
            result = allPartitionNames;
        }
        return result;
    }

    @Override
    public List<String> getPartitionNames(DataSourceAdapter datasource, TableMeta tableMeta) throws SQLException {
        LinkedList<String> partitionNames = new LinkedList<String>();
        TableEntry tableEntry = tableMeta.getTableEntry();
        if (tableEntry != null) {
            if (tableEntry.isPartitionTable()) {
                Map partitionMap = tableEntry.getTablePart().getPartDesc().getPartNameIdMap();
                ArrayList list = new ArrayList(partitionMap.entrySet());
                list.sort(Map.Entry.comparingByValue());
                for (Map.Entry entry : list) {
                    partitionNames.add((String)entry.getKey());
                }
            }
        } else {
            try (Connection conn = datasource.getConnectionReadOnly();){
                String sql = "SELECT PARTITION_NAME FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' ORDER BY PARTITION_ORDINAL_POSITION";
                ResultSet resultSet = conn.prepareStatement(String.format(sql, datasource.getSchema(), tableMeta.getName())).executeQuery();
                while (resultSet.next()) {
                    String partName = resultSet.getString(1);
                    if (!StringUtils.isNotEmpty((String)partName)) continue;
                    partitionNames.add(partName);
                }
            }
            catch (Exception ex) {
                log.warn("Get partition names failed, tableName={}", (Object)tableMeta.getName(), (Object)ex);
            }
        }
        if (partitionNames.isEmpty()) {
            partitionNames.add("");
        }
        return partitionNames;
    }
}

