/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.sql;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.element.TimeColumn;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.core.data.Row;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SqlUtils {
    public static String getColumnListStr(List<ColumnMeta> cols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cols.size(); ++i) {
            sb.append(String.format("%s%s", i == 0 ? "" : ", ", SqlUtils.quoteMySQLIdentifier(cols.get(i).getName())));
        }
        return sb.toString();
    }

    public static String getOracleColumnListStr(List<ColumnMeta> cols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cols.size(); ++i) {
            sb.append(String.format("%s%s", i == 0 ? "" : ", ", SqlUtils.quoteOracleIdentifier(cols.get(i).getName())));
        }
        return sb.toString();
    }

    public static String getEqualColumnCondition(TableMeta tableMeta, PrimaryKey key, int colIdx) {
        ArrayList<Integer> colIdxs = new ArrayList<Integer>();
        colIdxs.add(colIdx);
        if (tableMeta.getDataBaseType().isOracle()) {
            return SqlUtils.getOracleEqualColumnCondition(tableMeta, key, colIdx);
        }
        return SqlUtils.getKeyExpr(tableMeta, key, colIdxs, ExprCondition.EQUAL);
    }

    public static String getMinColumnCondition(TableMeta tableMeta, PrimaryKey minKey, int colIdx) {
        ArrayList<Integer> colIdxs = new ArrayList<Integer>();
        colIdxs.add(colIdx);
        if (tableMeta.getDataBaseType().isOracle()) {
            return SqlUtils.getOracleMinColumnCondition(tableMeta, minKey, colIdx);
        }
        return SqlUtils.getKeyExpr(tableMeta, minKey, colIdxs, ExprCondition.GREATER_THAN);
    }

    public static String getMaxColumnCondition(TableMeta tableMeta, PrimaryKey maxKey, int colIdx) {
        ArrayList<Integer> colIdxs = new ArrayList<Integer>();
        colIdxs.add(colIdx);
        if (tableMeta.getDataBaseType().isOracle()) {
            return SqlUtils.getOracleMaxColumnCondition(tableMeta, maxKey, colIdx);
        }
        return SqlUtils.getKeyExpr(tableMeta, maxKey, colIdxs, ExprCondition.LESS_THAN);
    }

    public static String getMinkeyCondition(TableMeta tableMeta, PrimaryKey minKey) {
        if (tableMeta.getDataBaseType().isOracle()) {
            return SqlUtils.getOracleMinkeyCondition(tableMeta, minKey);
        }
        return SqlUtils.getKeyCondition(tableMeta, minKey, ExprCondition.GREATER_THAN);
    }

    public static String getMaxkeyCondition(TableMeta tableMeta, PrimaryKey maxKey) {
        if (tableMeta.getDataBaseType().isOracle()) {
            return SqlUtils.getOracleMaxKeyCondition(tableMeta, maxKey);
        }
        return SqlUtils.getKeyCondition(tableMeta, maxKey, ExprCondition.LESS_THAN);
    }

    private static String getKeyCondition(TableMeta tableMeta, PrimaryKey key, ExprCondition exprCondition) {
        ArrayList<Integer> colIdxs = null;
        if (key != null) {
            colIdxs = new ArrayList<Integer>();
            for (int i = 0; i < key.getColumnCount(); ++i) {
                colIdxs.add(i);
            }
        }
        return SqlUtils.getKeyExpr(tableMeta, key, colIdxs, exprCondition);
    }

    public static String getOracleEqualColumnCondition(TableMeta tableMeta, PrimaryKey key, int colIdx) {
        ArrayList<Integer> colIdxs = new ArrayList<Integer>();
        colIdxs.add(colIdx);
        return SqlUtils.getOracleKeyExpr(tableMeta, key, colIdxs, ExprCondition.EQUAL);
    }

    public static String getOracleMinColumnCondition(TableMeta tableMeta, PrimaryKey minKey, int colIdx) {
        ArrayList<Integer> colIdxs = new ArrayList<Integer>();
        colIdxs.add(colIdx);
        return SqlUtils.getOracleKeyExpr(tableMeta, minKey, colIdxs, ExprCondition.GREATER_THAN);
    }

    public static String getOracleMaxColumnCondition(TableMeta tableMeta, PrimaryKey maxKey, int colIdx) {
        ArrayList<Integer> colIdxs = new ArrayList<Integer>();
        colIdxs.add(colIdx);
        return SqlUtils.getOracleKeyExpr(tableMeta, maxKey, colIdxs, ExprCondition.LESS_THAN);
    }

    public static String getOracleMinkeyCondition(TableMeta tableMeta, PrimaryKey minKey) {
        return SqlUtils.getOracleKeyCondition(tableMeta, minKey, ExprCondition.GREATER_THAN);
    }

    public static String getOracleMaxKeyCondition(TableMeta tableMeta, PrimaryKey maxKey) {
        return SqlUtils.getOracleKeyCondition(tableMeta, maxKey, ExprCondition.LESS_THAN);
    }

    public static String getOracleKeyCondition(TableMeta tableMeta, PrimaryKey key, ExprCondition exprCondition) {
        ArrayList<Integer> colIdxs = null;
        if (key != null) {
            colIdxs = new ArrayList<Integer>();
            for (int i = 0; i < key.getColumnCount(); ++i) {
                colIdxs.add(i);
            }
        }
        return SqlUtils.getOracleKeyExpr(tableMeta, key, colIdxs, exprCondition);
    }

    private static String getKeyExpr(TableMeta tableMeta, PrimaryKey key, ArrayList<Integer> colIdxs, ExprCondition exprCondition) {
        if (tableMeta == null) {
            throw new UnExpectedException("table Meta should not be null here");
        }
        if (key == null || key.isNull()) {
            return "";
        }
        if (tableMeta.getShardKeyColumns().size() < key.getColumnCount()) {
            throw new UnExpectedException("table meta column count should not less than key column count");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" (");
        for (int i = 0; i < colIdxs.size(); ++i) {
            if (i == 0) {
                builder.append(tableMeta.getShardKeyColumns().get(colIdxs.get(i)).getName());
                continue;
            }
            builder.append(", ").append(tableMeta.getShardKeyColumns().get(colIdxs.get(i)).getName());
        }
        builder.append(" )");
        switch (exprCondition) {
            case LESS_THAN: {
                if (key.isIncluded()) {
                    builder.append(" <= ");
                    break;
                }
                builder.append(" < ");
                break;
            }
            case GREATER_THAN: {
                if (key.isIncluded()) {
                    builder.append(" >= ");
                    break;
                }
                builder.append(" > ");
                break;
            }
            case EQUAL: {
                builder.append(" = ");
            }
        }
        builder.append(" (");
        AbstractSqlBuilder sqlBuilder = SqlBuilderFactory.getSqlBuilder(tableMeta.getDataBaseType());
        for (int i = 0; i < colIdxs.size(); ++i) {
            if (i == 0) {
                builder.append(sqlBuilder.getSqlString(key.getPrimaryKeyColumn(colIdxs.get(i))));
                continue;
            }
            builder.append(", ").append(sqlBuilder.getSqlString(key.getPrimaryKeyColumn(colIdxs.get(i))));
        }
        builder.append(" )");
        return builder.toString();
    }

    private static String getOracleKeyExpr(TableMeta tableMeta, PrimaryKey key, ArrayList<Integer> colIdxs, ExprCondition exprCondition) {
        if (tableMeta == null) {
            throw new UnExpectedException("table Meta should not be null here");
        }
        if (key == null || key.isNull()) {
            return "";
        }
        if (tableMeta.getShardKeyColumns().size() < key.getColumnCount()) {
            throw new UnExpectedException("table meta column count should not less than key column count");
        }
        String exprSql = "";
        exprSql = exprCondition == ExprCondition.EQUAL ? SqlUtils.resolveOraclePkEqual(tableMeta, key, colIdxs) : SqlUtils.resloveOraclePk(tableMeta, key, colIdxs, exprCondition);
        return exprSql;
    }

    private static String resolveOraclePkEqual(TableMeta tableMeta, PrimaryKey key, ArrayList<Integer> colIdxs) {
        StringBuilder builder = new StringBuilder();
        AbstractSqlBuilder sqlBuilder = SqlBuilderFactory.getSqlBuilder(tableMeta.getDataBaseType());
        builder.append(" (");
        for (int i = 0; i < colIdxs.size(); ++i) {
            if (i > 0) {
                builder.append(" and ");
            }
            builder.append(SqlUtils.quoteOracleIdentifier(tableMeta.getShardKeyColumns().get(colIdxs.get(i)).getName()));
            builder.append(" = ");
            builder.append(sqlBuilder.getSqlString(key.getPrimaryKeyColumn(colIdxs.get(i))));
        }
        builder.append(" )");
        return builder.toString();
    }

    private static String resloveOraclePk(TableMeta tableMeta, PrimaryKey key, ArrayList<Integer> colIdxs, ExprCondition exprCondition) {
        StringBuilder builder = new StringBuilder();
        AbstractSqlBuilder sqlBuilder = SqlBuilderFactory.getSqlBuilder(tableMeta.getDataBaseType());
        builder.append(" (");
        for (int i = 0; i < colIdxs.size(); ++i) {
            builder.append("(");
            for (int j = 0; j <= i; ++j) {
                if (i == j) {
                    builder.append(SqlUtils.quoteOracleIdentifier(tableMeta.getShardKeyColumns().get(colIdxs.get(j)).getName()));
                    switch (exprCondition) {
                        case LESS_THAN: {
                            if (key.isIncluded() && j == colIdxs.size() - 1) {
                                builder.append(" <= ");
                                break;
                            }
                            builder.append(" < ");
                            break;
                        }
                        case GREATER_THAN: {
                            if (key.isIncluded() && j == colIdxs.size() - 1) {
                                builder.append(" >= ");
                                break;
                            }
                            builder.append(" > ");
                        }
                    }
                    builder.append(sqlBuilder.getSqlString(key.getPrimaryKeyColumn(colIdxs.get(j))));
                    if (j >= colIdxs.size() - 1) continue;
                    builder.append(")");
                    builder.append(" or ");
                    continue;
                }
                builder.append(SqlUtils.quoteOracleIdentifier(tableMeta.getShardKeyColumns().get(colIdxs.get(j)).getName()));
                builder.append(" = ");
                builder.append(sqlBuilder.getSqlString(key.getPrimaryKeyColumn(colIdxs.get(j))));
                builder.append(" and ");
            }
        }
        builder.append(" ))");
        return builder.toString();
    }

    public static String getColumnRefList(int columnCount) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < columnCount; ++i) {
            if (i < columnCount - 1) {
                builder.append("?,");
                continue;
            }
            builder.append("?)");
        }
        return builder.toString();
    }

    public static void setPreparedStatement(PreparedStatement ps, Row row) throws SQLException {
        List<Column> columnList = row.getColumnList();
        for (int i = 0; i < columnList.size(); ++i) {
            SqlUtils.setPsParam(ps, i + 1, columnList.get(i));
        }
    }

    public static void setPsParam(PreparedStatement ps, int index, Column column) throws SQLException {
        switch (column.getType()) {
            case NUMBER: {
                if (column.getString() == null) {
                    ps.setNull(index, 3);
                    break;
                }
                BigDecimal bigDecimal = new BigDecimal(column.getString());
                ps.setBigDecimal(index, bigDecimal);
                break;
            }
            case BYTES: {
                byte[] b = (byte[])column.getValue();
                if (b == null) {
                    ps.setNull(index, -2);
                    break;
                }
                ps.setBytes(index, b);
                break;
            }
            case ORACLE_DATE: 
            case ORACLE_TIMESTAMP: {
                ps.setTimestamp(index, Timestamp.valueOf(column.getString()));
                break;
            }
            default: {
                ps.setString(index, column.getString());
            }
        }
    }

    public static String getColumnListString(TableMeta tableMeta) {
        StringBuilder builder = new StringBuilder();
        List<ColumnMeta> columnMetas = tableMeta.getColumnMetas();
        for (int i = 0; i < columnMetas.size(); ++i) {
            if (i == 0) {
                builder.append(columnMetas.get(i).getName());
                continue;
            }
            builder.append(String.format(", %s", SqlUtils.quoteIdentifier(columnMetas.get(i).getName(), tableMeta.getDataBaseType())));
        }
        return builder.toString();
    }

    public static String getOracleUpdateListString(TableMeta tableMeta) {
        StringBuilder builder = new StringBuilder();
        List<ColumnMeta> columnMetas = tableMeta.getColumnMetas();
        for (ColumnMeta columnMeta : columnMetas) {
            if (columnMeta.isShardKeyColumn()) continue;
            builder.append(" ").append(SqlUtils.quoteIdentifier(columnMeta.getName(), tableMeta.getDataBaseType())).append("=values(").append(columnMeta.getName()).append("),");
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String getUpdateListString(TableMeta tableMeta) {
        StringBuilder builder = new StringBuilder();
        List<ColumnMeta> columnMetas = tableMeta.getColumnMetas();
        for (ColumnMeta columnMeta : columnMetas) {
            if (columnMeta.isShardKeyColumn()) continue;
            builder.append(" `").append(columnMeta.getName()).append("`=values(`").append(columnMeta.getName()).append("`),");
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String getSingleGetCondition(List<ColumnMeta> columnMetas, DataBaseType dbType) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < columnMetas.size(); ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(SqlUtils.quoteIdentifier(columnMetas.get(i).getName(), dbType));
        }
        builder.append(") = (");
        for (int j = 0; j < columnMetas.size(); ++j) {
            if (j != 0) {
                builder.append(",");
            }
            builder.append("?");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String getMultiGetCondition(List<ColumnMeta> columnMetas, int batchSize, DataBaseType dbType) {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (i = 0; i < columnMetas.size(); ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(SqlUtils.quoteIdentifier(columnMetas.get(i).getName(), dbType));
        }
        builder.append(") in (");
        for (i = 0; i < batchSize; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("(");
            for (int j = 0; j < columnMetas.size(); ++j) {
                if (j != 0) {
                    builder.append(",");
                }
                builder.append("?");
            }
            builder.append(")");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String formatDateString(String dateString, String dateFormat) throws DefinedException {
        Date date;
        String result = null;
        SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            date = inputDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new DefinedException(ErrorType.INVALID_DATE_FORMAT, e.getMessage());
        }
        int startIndex = dateFormat.indexOf("%");
        if (-1 == startIndex) {
            throw new DefinedException(ErrorType.INVALID_DATE_FORMAT, "invalid date format: " + dateFormat);
        }
        String prefix = dateFormat.substring(0, startIndex);
        String formatString = dateFormat.substring(startIndex).toLowerCase();
        formatString = formatString.replace("%y", "yyyy");
        formatString = formatString.replace("%m", "MM");
        formatString = formatString.replace("%d", "dd");
        SimpleDateFormat outputDateFormat = new SimpleDateFormat(formatString);
        result = prefix + outputDateFormat.format(date);
        return result;
    }

    public static String formatOracleDateString(String dateString, String dateFormat, DataType dataType) {
        TimeColumn strColumn = new TimeColumn(dataType, dateString, dateFormat);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        String result = sqlBuilder.getSqlString(strColumn);
        return result;
    }

    public static String quoteIdentifier(String identifier, DataBaseType dbType) {
        return dbType.isMySQL() ? "`" + identifier + "`" : "\"" + identifier + "\"";
    }

    public static String quoteOracleIdentifier(String identifier) {
        return SqlUtils.quoteIdentifier(identifier, DataBaseType.ORACLE);
    }

    public static String quoteMySQLIdentifier(String identifier) {
        return SqlUtils.quoteIdentifier(identifier, DataBaseType.MYSQL);
    }

    public static enum ExprCondition {
        LESS_THAN,
        GREATER_THAN,
        EQUAL;

    }
}

