/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.element;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringColumn
extends Column {
    private static final Logger log = LoggerFactory.getLogger(StringColumn.class);
    protected String value = null;
    protected String format = null;

    public StringColumn(DataType type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public long getByteSize() {
        return this.value == null ? 1L : (long)this.value.length();
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public Long getLong() {
        Long v = null;
        try {
            v = Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            log.info(String.format("fail to parse String column to Long column,String column = [%s]", this.toString()));
        }
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringColumn that = (StringColumn)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean isMatch(Column c) {
        if (c.type != this.type) {
            return false;
        }
        boolean ret = false;
        StringColumn stringColumn = (StringColumn)c;
        if (this.value == null && stringColumn.value == null) {
            ret = true;
        } else if (this.value == null || stringColumn.value == null) {
            ret = false;
        } else {
            switch (this.type) {
                case DECIMAL: 
                case NUMBER: 
                case LONG: 
                case DOUBLE: {
                    BigDecimal thisBigDecimal = new BigDecimal(this.value);
                    BigDecimal otherBigDecimal = new BigDecimal(stringColumn.value);
                    ret = thisBigDecimal.compareTo(otherBigDecimal) == 0;
                    break;
                }
                case TIMESTAMP: 
                case ORACLE_TIMESTAMP: 
                case DATETIME: 
                case ORACLE_DATE: {
                    Timestamp thisTimestamp = Timestamp.valueOf(this.value);
                    Timestamp otherTimestamp = Timestamp.valueOf(stringColumn.value);
                    ret = thisTimestamp.equals(otherTimestamp);
                    break;
                }
                default: {
                    ret = this.value.equals(stringColumn.value);
                }
            }
        }
        return ret;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("columnType", (Object)this.type).append("value", (Object)this.value).toString();
    }

    @Override
    public Object getValue() {
        return this.value;
    }
}

