/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils {
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);

    public static void closeQuietly(ResultSet resultSet) {
        try {
            if (null != resultSet) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            log.warn("failed to close resultSet", (Throwable)e);
        }
    }

    public static void closeQuietly(Statement statement) {
        try {
            if (null != statement) {
                statement.close();
            }
        }
        catch (SQLException e) {
            log.warn("failed to close statement", (Throwable)e);
        }
    }

    public static void closeQuietly(PreparedStatement preparedStatement) {
        try {
            if (null != preparedStatement) {
                preparedStatement.close();
            }
        }
        catch (SQLException e) {
            log.warn("failed to close preparedStatement", (Throwable)e);
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            if (null != connection) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.warn("failed to close connection", (Throwable)e);
        }
    }

    public static void autoCommitAndCloseQuietly(Connection connection) {
        try {
            if (null != connection) {
                connection.setAutoCommit(true);
                connection.close();
            }
        }
        catch (SQLException e) {
            log.warn("failed to close connection", (Throwable)e);
        }
    }
}

