/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class ResourceIdUtils {
    static final char[] digits = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long twepoch = 1535731200000L;
    private static final long workerIdBits = 17L;
    private final long datacenterIdBits = 5L;
    private final long maxWorkerId = 131071L;
    private static final long sequenceBits = 5L;
    private static final long workerIdShift = 5L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 31L;
    private static long workerId;
    private static long sequence;
    private static long lastTimestamp;

    public static String toString(long i, SystemEnum systemEnum) {
        int bit = 64;
        int system = systemEnum.valueOf();
        long num = i < 0L ? 0xFFFFFFFEL + i + 2L : i;
        char[] buf = new char[bit];
        int charPos = bit;
        while (num / (long)system > 0L) {
            buf[--charPos] = digits[(int)(num % (long)system)];
            num /= (long)system;
        }
        buf[--charPos] = digits[(int)(num % (long)system)];
        return new String(buf, charPos, bit - charPos);
    }

    public static long toLong(String s, SystemEnum systemEnum) {
        int system = systemEnum.valueOf();
        char[] buf = new char[s.length()];
        s.getChars(0, s.length(), buf, 0);
        long num = 0L;
        block0: for (int i = 0; i < buf.length; ++i) {
            for (int j = 0; j < digits.length; ++j) {
                if (digits[j] != buf[i]) continue;
                num = (long)((double)num + (double)j * Math.pow(system, buf.length - i - 1));
                continue block0;
            }
        }
        return num;
    }

    public static long getWorkerId() {
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String jvmName = bean.getName();
        long pid = Long.valueOf(jvmName.split("@")[0]);
        return pid + threadId;
    }

    public static synchronized long nextId() {
        long timestamp = ResourceIdUtils.timeGen();
        workerId = ResourceIdUtils.getWorkerId();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0x1FL) == 0L) {
                timestamp = ResourceIdUtils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1535731200000L << 22 | workerId << 5 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = ResourceIdUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = ResourceIdUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    public static String getResourceId(String domain) {
        return domain == null ? String.format("%s", ResourceIdUtils.toString(ResourceIdUtils.nextId(), SystemEnum.THIRTY_SIX)) : String.format("%s_%s", domain, ResourceIdUtils.toString(ResourceIdUtils.nextId(), SystemEnum.THIRTY_SIX));
    }

    public String getResourceIdWithoutUnderline(String domain) {
        return domain == null ? String.format("%s", ResourceIdUtils.toString(ResourceIdUtils.nextId(), SystemEnum.THIRTY_SIX)) : String.format("%s%s", domain, ResourceIdUtils.toString(ResourceIdUtils.nextId(), SystemEnum.THIRTY_SIX));
    }

    static {
        sequence = 0L;
        lastTimestamp = -1L;
    }

    public static enum SystemEnum {
        BINARY(2),
        OCTAL(8),
        HEX(16),
        THIRTY_TWO(32),
        THIRTY_SIX(36),
        SIXTY_TWO(62);

        private final int nCode;

        private SystemEnum(int nCode) {
            this.nCode = nCode;
        }

        public int valueOf() {
            return this.nCode;
        }

        public String toString() {
            return String.valueOf(this.nCode);
        }
    }
}

