/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.data;

import com.oceanbase.tools.migrator.common.configure.DirtyRowAction;
import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.core.data.AbstractData;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.handler.DataWriteHandler;
import com.oceanbase.tools.migrator.core.handler.MultiGetHandler;
import com.oceanbase.tools.migrator.core.meta.TaskMeta;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransRows
extends AbstractData {
    private static final Logger log = LoggerFactory.getLogger(TransRows.class);
    private List<BatchRows> batchRowsList = new ArrayList<BatchRows>(1);
    private TaskMeta ownerTaskMeta = null;
    private int readRowCount = 0;
    private int rowCount = 0;
    private long dataSize = 0L;
    private ErrorType errorType = ErrorType.CLEAN;
    private String errorMsg = null;
    private boolean finished = false;
    private PrimaryKey cursorKey = null;
    private boolean isDirty = false;
    private boolean hasDirty = false;

    @Override
    public AbstractData getOwner() {
        return this.ownerTaskMeta;
    }

    public TaskMeta getOwnerTaskMeta() {
        return this.ownerTaskMeta;
    }

    public void setOwnerTaskMeta(TaskMeta ownerTaskMeta) {
        this.ownerTaskMeta = ownerTaskMeta;
    }

    public void addBatchRows(BatchRows rows) {
        this.rowCount += rows.getRowCount();
        this.dataSize += rows.getDataSize();
        this.readRowCount += rows.getReadRowCount();
        rows.setOwnerTransRows(this);
        this.batchRowsList.add(rows);
    }

    public void addReadRows(BatchRows rows) {
        this.rowCount += rows.getRowCount();
        this.dataSize += rows.getDataSize();
        this.readRowCount += rows.getReadRowCount();
        rows.setOwnerTransRows(this);
    }

    public int getReadRowCount() {
        return this.readRowCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public BatchRows getMainBatchRows() {
        if (this.batchRowsList.size() < 1) {
            throw new UnExpectedException("batch Rows should not be null here");
        }
        return this.batchRowsList.get(0);
    }

    public BatchRows getBatchRows(int i) {
        return this.batchRowsList.get(i);
    }

    public int getBatchRowsCount() {
        return this.batchRowsList.size();
    }

    public PrimaryKey getMinPrimaryKey() {
        return this.getMainBatchRows().getMinPrimaryKey();
    }

    public PrimaryKey getMaxPrimaryKey() {
        return this.getMainBatchRows().getMaxPrimaryKey();
    }

    public boolean isMatch(TransRows targetTransRows) {
        if (targetTransRows == null) {
            String errMsg = String.format("table name = %s, srcMinKey = %s, srcMaxKey = %s, srcTransRowCount = %d, targetTransRow is null", this.ownerTaskMeta.getJobMeta().getSourceTableMeta().getName(), this.getMinPrimaryKey().toSqlString(), this.getMaxPrimaryKey().toSqlString(), this.rowCount);
            this.setError(ErrorType.CHECK_RECORD_COUNT_NOT_MATCH, errMsg);
            log.error("check record count not match, " + errMsg);
            return false;
        }
        List<BatchRows> srcBatchRowsList = this.batchRowsList;
        List<BatchRows> targetBatchRowsList = targetTransRows.batchRowsList;
        if (srcBatchRowsList.size() != targetBatchRowsList.size()) {
            String errMsg = String.format("srcCount = %d, targetCount = %d", srcBatchRowsList.size(), targetBatchRowsList.size());
            this.setError(ErrorType.CHECK_TABLE_COUNT_NOT_MATCH, errMsg);
            log.error("check table counts are not matched, " + errMsg);
            return false;
        }
        for (int i = 0; i < srcBatchRowsList.size(); ++i) {
            if (!srcBatchRowsList.get(i).isMatch(targetBatchRowsList.get(i)) && !this.ownerTaskMeta.getJobMeta().getDirtyRowAction().equals((Object)DirtyRowAction.REMIGRATE)) {
                return false;
            }
            if (!this.ownerTaskMeta.getJobMeta().getDirtyRowAction().equals((Object)DirtyRowAction.REMIGRATE) || !this.hasDirty) continue;
            try {
                DataWriteHandler.write(this);
                int retryCount = 10;
                int initSleepTimeMs = 10;
                int maxSleepTimeMs = 5000;
                int sleepTimeMs = initSleepTimeMs;
                try {
                    Thread.sleep(initSleepTimeMs);
                }
                catch (InterruptedException e) {
                    log.info("interrupted", (Throwable)e);
                }
                boolean isMatchResult = false;
                for (int j = 0; this.hasDirty && j < retryCount; ++j) {
                    try {
                        this.resetDirty();
                        TransRows newTargetTransRows = MultiGetHandler.multiGetTargetTransRows(this);
                        List<BatchRows> newTargetBatchRowsList = newTargetTransRows.batchRowsList;
                        if (!srcBatchRowsList.get(i).isMatch(newTargetBatchRowsList.get(i))) {
                            log.warn(String.format("after remigrate,data is not match,will retry,  %d/%d", j + 1, retryCount));
                        } else {
                            log.warn("after remigrate,data is match");
                        }
                    }
                    catch (SQLException e) {
                        if (j < retryCount - 1) {
                            log.warn(String.format("exception comes, will retry, %d/%d", j + 1, retryCount), (Throwable)e);
                        }
                        log.warn("exception comes, this is the last round", (Throwable)e);
                        throw e;
                    }
                    if (!this.hasDirty) continue;
                    log.info(String.format("still not match, will sleep for %d ms", sleepTimeMs));
                    try {
                        Thread.sleep(sleepTimeMs);
                    }
                    catch (InterruptedException e) {
                        log.info("interrupted", (Throwable)e);
                        retryCount = 0;
                    }
                    sleepTimeMs = sleepTimeMs * 2 > maxSleepTimeMs ? maxSleepTimeMs : sleepTimeMs * 2;
                }
                continue;
            }
            catch (SQLException e) {
                log.error(String.format("table %s remigrate failed, cause %s", this.ownerTaskMeta.getJobMeta().getSourceTableMeta().getName(), e));
            }
        }
        return true;
    }

    @Override
    public void setError(ErrorType type, String errorMessage) {
        boolean throwError = true;
        this.errorType = type;
        this.errorMsg = errorMessage;
        this.isDirty = true;
        switch (type) {
            case CHECK_RECORD_COUNT_NOT_MATCH: 
            case CHECK_ROW_NOT_EXISTS_IN_TARGET: {
                if (!this.ownerTaskMeta.getJobMeta().isEnableImpreciseSavePoint() && !this.ownerTaskMeta.getJobMeta().getDirtyRowAction().equals((Object)DirtyRowAction.REMIGRATE)) break;
                throwError = false;
                break;
            }
        }
        this.ownerTaskMeta.getJobMeta().getJobStat().addUnMatchedRowCount(this.rowCount);
        if (throwError) {
            super.setError(type, errorMessage);
        }
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public PrimaryKey getCursorKey() {
        return this.cursorKey;
    }

    public void setCursorKey(PrimaryKey cursorKey) {
        this.cursorKey = cursorKey;
    }

    public boolean hasSubTable() {
        return this.batchRowsList.size() > 1;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void resetDirty() {
        this.isDirty = false;
        this.hasDirty = false;
        for (BatchRows batchRows : this.batchRowsList) {
            batchRows.resetDirtyRows();
        }
    }

    public void setHasDirty(boolean hasDirty) {
        this.hasDirty = hasDirty;
    }
}

