/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler;

import com.oceanbase.tools.migrator.common.configure.SubTableInfo;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.builder.SqlBuilderFactory;
import com.oceanbase.tools.migrator.core.data.BatchRows;
import com.oceanbase.tools.migrator.core.handler.MultiGetHandler;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGetSubHandler {
    private static final Logger log = LoggerFactory.getLogger(MultiGetSubHandler.class);

    public static BatchRows multiGetSubBatchRows(Connection connection, BatchRows primaryTableBatchRows, SubTableInfo subTableInfo) throws SQLException {
        BatchRows batchRows = null;
        JobMeta jobMeta = primaryTableBatchRows.getOwnerTransRows().getOwnerTaskMeta().getJobMeta();
        TableMeta primaryTableMeta = primaryTableBatchRows.getTableMeta();
        TableMeta subTableMeta = jobMeta.getSourceTableMeta(subTableInfo.getTableName());
        int batchSize = jobMeta.getJobParameter().getMultiGetBatchSize();
        if (!subTableInfo.getAssociatedKey().contains("@")) {
            List<ColumnMeta> multiGetKeyColumnMetas = MultiGetSubHandler.buildMultiGetColumnMetas(primaryTableMeta, subTableInfo);
            String preparedSubTableSql = MultiGetSubHandler.getPreparedMultiGetSubSql(subTableMeta, multiGetKeyColumnMetas, subTableInfo, batchSize);
            if (jobMeta.getNeedPrintSqlTrace().booleanValue()) {
                log.info(String.format("getPreparedMultiGetSubSql = [%s]", preparedSubTableSql));
            }
            batchRows = MultiGetHandler.getBatchRowsWithMultiget(connection, preparedSubTableSql, primaryTableBatchRows, multiGetKeyColumnMetas, batchSize, subTableInfo.getAdditionKeyValue());
        } else {
            List<ColumnMeta> multiGetKeyColumnMetas = MultiGetSubHandler.buildMultiGetColumnMetas(primaryTableMeta, subTableInfo);
            List<ColumnMeta> multiGetKeySubColumnMetas = MultiGetSubHandler.buildMultiGetSubColumnMetas(subTableMeta, subTableInfo);
            String preparedSubTableSql = MultiGetSubHandler.getPreparedMultiGetSubSql(subTableMeta, multiGetKeySubColumnMetas, subTableInfo, batchSize);
            if (jobMeta.getNeedPrintSqlTrace().booleanValue()) {
                log.info(String.format("getPreparedMultiGetSubSql = [%s]", preparedSubTableSql));
            }
            batchRows = MultiGetHandler.getBatchRowsWithMultiget(connection, preparedSubTableSql, primaryTableBatchRows, multiGetKeyColumnMetas, batchSize);
        }
        if (batchRows != null) {
            batchRows.setTableMeta(subTableMeta);
            batchRows.setScanRowCount(primaryTableBatchRows.getRowCount());
        }
        return batchRows;
    }

    private static List<ColumnMeta> buildMultiGetColumnMetas(TableMeta primaryTableMeta, SubTableInfo subTableInfo) {
        if (subTableInfo.getAssociatedKey().length() == 0) {
            return primaryTableMeta.getShardKeyColumns();
        }
        String[] columnNames = subTableInfo.getAssociatedKey().split(",");
        ArrayList<ColumnMeta> multiGetColumns = new ArrayList<ColumnMeta>(columnNames.length);
        if (subTableInfo.getAssociatedKey().contains("@")) {
            block0: for (String columnName : columnNames) {
                if (columnName.contains("@")) {
                    String[] columnPair = columnName.trim().split("@");
                    if (columnPair.length != 2) {
                        throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "unexpected AssociatedKey contains '@' : " + columnName);
                    }
                    for (ColumnMeta columnMeta : primaryTableMeta.getColumnMetas()) {
                        if (!columnMeta.getName().equalsIgnoreCase(columnPair[0])) continue;
                        multiGetColumns.add(columnMeta);
                        continue block0;
                    }
                    continue;
                }
                for (ColumnMeta columnMeta : primaryTableMeta.getColumnMetas()) {
                    if (!columnMeta.getName().equalsIgnoreCase(columnName.trim())) continue;
                    multiGetColumns.add(columnMeta);
                    continue block0;
                }
            }
        } else {
            block3: for (ColumnMeta columnMeta : primaryTableMeta.getColumnMetas()) {
                for (String columnName : columnNames) {
                    if (!columnMeta.getName().equalsIgnoreCase(columnName.trim())) continue;
                    multiGetColumns.add(columnMeta);
                    continue block3;
                }
            }
        }
        if (multiGetColumns.size() <= 0) {
            throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "multi get column should not be 0");
        }
        return multiGetColumns;
    }

    private static List<ColumnMeta> buildMultiGetSubColumnMetas(TableMeta subTableMeta, SubTableInfo subTableInfo) {
        String[] columnNames = subTableInfo.getAssociatedKey().split(",");
        ArrayList<ColumnMeta> multiGetTargetColumn = new ArrayList<ColumnMeta>();
        block0: for (String columnName : columnNames) {
            if (columnName.contains("@")) {
                String[] columnPair = columnName.trim().split("@");
                if (columnPair.length != 2) {
                    throw new DefinedException(ErrorType.UNEXPECTED_ERROR, "unexpected AssociatedKey contains '@' : " + columnName);
                }
                for (ColumnMeta columnMeta : subTableMeta.getColumnMetas()) {
                    if (!columnMeta.getName().equalsIgnoreCase(columnPair[1])) continue;
                    multiGetTargetColumn.add(columnMeta);
                    continue block0;
                }
                continue;
            }
            for (ColumnMeta columnMeta : subTableMeta.getColumnMetas()) {
                if (!columnMeta.getName().equalsIgnoreCase(columnName.trim())) continue;
                multiGetTargetColumn.add(columnMeta);
                continue block0;
            }
        }
        return multiGetTargetColumn;
    }

    private static String getPreparedMultiGetSubSql(TableMeta subTableMeta, List<ColumnMeta> multiGetKeyColumnMetas, SubTableInfo subTableInfo, int batchSize) {
        AbstractSqlBuilder builder = SqlBuilderFactory.getSqlBuilder(subTableMeta.getDataBaseType());
        builder.setSelectColumns(subTableMeta.getColumnListStr());
        builder.setTableName(subTableMeta.getName());
        builder.addPrimaryKeyCondition(SqlUtils.getMultiGetCondition(multiGetKeyColumnMetas, batchSize, subTableMeta.getDataBaseType()));
        builder.addUserDefinedCondition(subTableInfo.getAdditionCond());
        builder.setOrderByColumns(subTableMeta.getShardKeyColumns());
        builder.setOrderByMethod(OrderByMethod.ASC);
        builder.setTableOwner(subTableMeta.getSchema());
        builder.setShardKeyName(subTableMeta.getShardKeyName());
        return builder.getReadDataSql();
    }
}

