/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.handler.keyReadIterator;

import com.oceanbase.tools.migrator.common.element.PrimaryKey;
import com.oceanbase.tools.migrator.core.builder.ObOracleSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.core.handler.keyReadIterator.KeyReadIterator;
import com.oceanbase.tools.migrator.sql.SqlUtils;

public class ObOracleKeyReadIterator
extends KeyReadIterator {
    @Override
    public String getMinBoundSql() {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        obOracleSqlBuilder.setTableOwner(this.dataSourceAdapter.getSchema());
        obOracleSqlBuilder.setTableName(this.tableName);
        obOracleSqlBuilder.setPartitionName(this.partitionName);
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.tableMeta, this.minKey));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.tableMeta, this.maxKey));
        obOracleSqlBuilder.setOrderByColumns(this.tableMeta.getShardKeyColumns());
        obOracleSqlBuilder.setOrderByMethod(OrderByMethod.ASC);
        obOracleSqlBuilder.setOffset(1);
        return obOracleSqlBuilder.getSplitSql();
    }

    @Override
    public String getMaxBoundSql(PrimaryKey lowerBound) {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        obOracleSqlBuilder.setTableOwner(this.dataSourceAdapter.getSchema());
        obOracleSqlBuilder.setTableName(this.tableName);
        obOracleSqlBuilder.setPartitionName(this.partitionName);
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.tableMeta, lowerBound));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.tableMeta, this.maxKey));
        obOracleSqlBuilder.setOrderByColumns(this.tableMeta.getShardKeyColumns());
        obOracleSqlBuilder.setOrderByMethod(OrderByMethod.DESC);
        obOracleSqlBuilder.setOffset(1);
        return obOracleSqlBuilder.getSplitSql();
    }

    @Override
    public String getUpperBoundSql(PrimaryKey lowerBound) {
        ObOracleSqlBuilder obOracleSqlBuilder = new ObOracleSqlBuilder();
        obOracleSqlBuilder.setSelectColumns(this.tableMeta.getPkColumnListStr());
        obOracleSqlBuilder.setTableOwner(this.dataSourceAdapter.getSchema());
        obOracleSqlBuilder.setTableName(this.tableName);
        obOracleSqlBuilder.setPartitionName(this.partitionName);
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMinkeyCondition(this.tableMeta, lowerBound));
        obOracleSqlBuilder.addPrimaryKeyCondition(SqlUtils.getMaxkeyCondition(this.tableMeta, this.maxKey));
        obOracleSqlBuilder.setOrderByColumns(this.tableMeta.getShardKeyColumns());
        obOracleSqlBuilder.setOrderByMethod(OrderByMethod.ASC);
        obOracleSqlBuilder.setOffset(this.batchSize);
        return obOracleSqlBuilder.getSplitSql();
    }
}

