/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.runner;

import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.JobException;
import com.oceanbase.tools.migrator.common.exception.JobInterruptedException;
import com.oceanbase.tools.migrator.common.exception.JobSqlException;
import com.oceanbase.tools.migrator.core.data.AbstractData;
import com.oceanbase.tools.migrator.core.tunnel.AbstractTunnel;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRunner<READ_TYPE extends AbstractData, WRITE_TYPE extends AbstractData>
implements Callable {
    private static final Logger log = LoggerFactory.getLogger(CommonRunner.class);
    protected AbstractTunnel<READ_TYPE> readTunnel = null;
    protected AbstractTunnel<WRITE_TYPE> writeTunnel = null;
    protected String name = "Default";

    public Void call() throws Exception {
        Thread.currentThread().setName(this.name);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                block12: {
                    AbstractData t = (AbstractData)this.readTunnel.take();
                    if (t != null) {
                        try {
                            this.run(t);
                            break block12;
                        }
                        catch (JobInterruptedException e) {
                            log.info("job is killed, stop running");
                            break;
                        }
                        catch (SQLException e) {
                            log.warn("failed to run", (Throwable)e);
                            t.setError(new JobSqlException(this.readTunnel.getJobMeta().getJobId(), e));
                            break;
                        }
                        catch (DefinedException e) {
                            log.warn(String.format("job failed, err = %s, errMsg = %s", new Object[]{e.getErrorType(), e.getMessage()}), (Throwable)e);
                            t.setError(new JobException(this.readTunnel.getJobMeta().getJobId(), e));
                            break;
                        }
                        catch (Exception e) {
                            log.warn("failed to run", (Throwable)e);
                            t.setError(new JobException(this.readTunnel.getJobMeta().getJobId(), e));
                            throw e;
                        }
                    }
                    log.info("take nothing, this thread will exit");
                    break;
                }
                if (this.readTunnel.getJobMeta().getJobError() != null) {
                    log.info("Job Has Error.");
                    break;
                }
                if (!this.readTunnel.getJobMeta().isToStop()) continue;
                log.info("Job Is To Stop.");
                break;
            }
            catch (InterruptedException e) {
                log.warn("interrupted", (Throwable)e);
                break;
            }
        }
        if (this.readTunnel != null) {
            this.readTunnel.decConsumer();
        }
        if (this.writeTunnel != null) {
            this.writeTunnel.decProducer();
        }
        return null;
    }

    public AbstractTunnel<READ_TYPE> getReadTunnel() {
        return this.readTunnel;
    }

    public void setReadTunnel(AbstractTunnel<READ_TYPE> readTunnel) {
        if (readTunnel != null) {
            this.readTunnel = readTunnel;
            this.readTunnel.incConsumer();
        }
    }

    public AbstractTunnel<WRITE_TYPE> getWriteTunnel() {
        return this.writeTunnel;
    }

    public void setWriteTunnel(AbstractTunnel<WRITE_TYPE> writeTunnel) {
        if (writeTunnel != null) {
            this.writeTunnel = writeTunnel;
            this.writeTunnel.incProducer();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    abstract void run(READ_TYPE var1) throws Exception;
}

