/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.tunnel;

import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.core.tunnel.TransRowsTunnel;
import com.oceanbase.tools.migrator.core.tunnel.limiter.DataSizeRateLimiter;
import com.oceanbase.tools.migrator.core.tunnel.limiter.RowRateLimiter;

public class DeleteTunnel
extends TransRowsTunnel {
    public DeleteTunnel(JobMeta jobMeta) {
        super(jobMeta);
        int sourceWriteSizeLimit = Math.min(jobMeta.getSourceCluster().getAvgWriteSizeLimit(), jobMeta.getSourceTenant().getAvgWriteSizeLimit());
        this.setTakeRowRateLimiter(new RowRateLimiter(jobMeta, jobMeta.getSourceTableMeta().getWriteRowCountLimit(), String.format("WriteRowLimiter(%s)", jobMeta.getSourceTableMeta().getName())));
        this.setTakeSizeRateLimiter(new DataSizeRateLimiter(jobMeta, sourceWriteSizeLimit, String.format("WriteDataSizeLimiter(%s)", jobMeta.getSourceCluster().getClusterName())));
    }

    @Override
    public void updateRateLimit() {
        int sourceWriteSizeLimit = Math.min(this.jobMeta.getSourceCluster().getAvgWriteSizeLimit(), this.jobMeta.getSourceTenant().getAvgWriteSizeLimit());
        this.getTakeRowRateLimiter().updateRate(this.jobMeta.getSourceTableMeta().getWriteRowCountLimit());
        this.getTakeSizeRateLimiter().updateRate(sourceWriteSizeLimit);
    }
}

