/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.ExceptionSorter;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.common.dto.TableSizeInfo;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.util.OBVersionUtil;
import com.oceanbase.tools.migrator.datasource.AbstractObDataSourceAdapter;
import com.oceanbase.tools.migrator.datasource.ObOracleExceptionSorter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleModeDataSourceAdapter
extends AbstractObDataSourceAdapter {
    private static final Logger log = LoggerFactory.getLogger(ObOracleModeDataSourceAdapter.class);

    public ObOracleModeDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        if (conf.getPassword() != null) {
            properties.setProperty("password", conf.getPassword());
        }
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:oceanbase://%s:%d/%s?useUnicode=true&characterEncoding=utf-8", conf.getIp(), conf.getPort(), conf.getDatabaseName());
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("initConnectionSqls", "set character_set_results=utf8;");
        properties.setProperty("driverClassName", "com.alipay.oceanbase.obproxy.mysql.jdbc.Driver");
        properties.setProperty("validationQuery", "select 1 from dual");
        this.dataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        ArrayList<String> initSqls = new ArrayList<String>(4);
        initSqls.add("ALTER SESSION SET NLS_DATE_FORMAT='YYYY-MM-DD HH24:MI:SS';");
        initSqls.add("ALTER SESSION SET NLS_TIMESTAMP_FORMAT='YYYY-MM-DD HH24:MI:SS.FF';");
        initSqls.add("ALTER SESSION SET NLS_TIMESTAMP_TZ_FORMAT='YYYY-MM-DD HH24:MI:SS.FF TZR TZD';");
        initSqls.add("set @@ob_org_cluster_id = 2147473648");
        this.dataSource.setConnectionInitSqls(initSqls);
        this.dataSource.setExceptionSorter((ExceptionSorter)new ObOracleExceptionSorter());
        this.sysDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
        this.obVersion = this.getDbVersion();
        if (StringUtils.isEmpty((String)this.obVersion)) {
            log.error("Get OB version failed.");
            throw new UnExpectedException("Get OB version failed.");
        }
        try (Connection conn = this.getConnectionReadOnly();){
            if (StringUtils.isEmpty((String)this.dataSourceInfo.getTenantName())) {
                this.dataSourceInfo.setTenantName(this.getCurrentTenantName(conn));
            }
            this.dataSourceInfo.setTenantId(this.getTenantId(this.dataSourceInfo.getTenantName(), conn));
            if (StringUtils.isEmpty((String)this.dataSourceInfo.getClusterName())) {
                this.dataSourceInfo.setClusterName(this.getClusterName(conn));
            }
        }
        this.setSleepTime(this.dataSourceInfo.getSleepTime());
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowWrite(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean isAllowDelete(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public TableSizeInfo getSourceTableSizeInfo(String tableName) throws SQLException {
        Connection conn = this.getConnection();
        Throwable throwable = null;
        if (conn != null) {
            if (throwable != null) {
                try {
                    conn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                conn.close();
            }
        }
        return new TableSizeInfo();
    }

    @Override
    protected String getQueryTenantIdSql(String tenantName) {
        return "select effective_tenant_id() as tenant_id from dual";
    }

    protected String getCurrentTenantName(Connection connection) throws SQLException {
        PreparedStatement ps = connection.prepareStatement("SELECT SYS_CONTEXT('USERENV', 'CON_NAME') AS TENANT_NAME FROM DUAL");
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getString("TENANT_NAME");
        }
        return null;
    }

    protected String getTenantMemQuerySql() {
        if (OBVersionUtil.isGreaterThanOB4X(this.obVersion)) {
            return String.format("SELECT 1 FROM SYS.gv$ob_memstore where TENANT_ID = '%s' AND (MEMSTORE_USED >= FREEZE_TRIGGER * 1.05);", this.dataSourceInfo.getTenantId());
        }
        return String.format("SELECT 1 FROM SYS.gv$memstore where CON_ID = '%s' AND (TOTAL >= FREEZE_TRIGGER * 1.05)", this.dataSourceInfo.getTenantId());
    }
}

