/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.oceanbase.tools.migrator.common.configure.DataSourceInfo;
import com.oceanbase.tools.migrator.datasource.AbstractDataSourceAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class OracleDataSourceAdapter
extends AbstractDataSourceAdapter {
    private DruidDataSource druidDataSource;
    private static final String ALL_TABLES = "ALL_TABLES";
    private static final String IS_PARTITION_TABLE_SQL = String.format("SELECT PARTITIONED FROM %s WHERE OWNER LIKE ? AND TABLE_NAME LIKE ? ", "ALL_TABLES");
    private static final String ALL_TAB_PARTITIONS = "ALL_TAB_PARTITIONS";
    private static final String GET_PARTITION_NAME_SQL = String.format("SELECT PARTITION_NAME FROM %s WHERE TABLE_OWNER LIKE ? AND TABLE_NAME LIKE ? ", "ALL_TAB_PARTITIONS");

    public OracleDataSourceAdapter(DataSourceInfo conf) throws Exception {
        super(conf);
        Properties properties = new Properties();
        properties.setProperty("username", conf.getFullUserName());
        properties.setProperty("password", conf.getPassword());
        properties.setProperty("maxActive", String.valueOf(conf.getConnectionCount()));
        properties.setProperty("minIdle", String.valueOf(0));
        String url = String.format("jdbc:oracle:thin:@%s:%d:%s", conf.getIp(), conf.getPort(), conf.getDatabaseName());
        properties.setProperty("url", url);
        properties.setProperty("connectionProperties", conf.getConnectionProperties() + "useSSL=false;");
        properties.setProperty("initialSize", String.valueOf(0));
        properties.setProperty("driverClassName", "oracle.jdbc.OracleDriver");
        this.druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
    }

    @Override
    public Connection getConnectionForWrite() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.druidDataSource.getConnection();
    }

    @Override
    public Connection getConnectionReadOnly() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnectionForDelete() throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getBackendConnection() throws SQLException {
        return null;
    }

    @Override
    public String getDbVersion() throws SQLException {
        return null;
    }

    @Override
    public void closeDataSource() {
        super.closeDataSource();
        if (this.druidDataSource != null) {
            this.druidDataSource.close();
        }
    }
}

