/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.job;

import com.oceanbase.tools.migrator.core.runner.CheckDataFromRecordRunner;
import com.oceanbase.tools.migrator.core.runner.DeleteDataFromRecordRunner;
import com.oceanbase.tools.migrator.core.runner.ReadDataFromTaskRunner;
import com.oceanbase.tools.migrator.core.tunnel.CheckTunnel;
import com.oceanbase.tools.migrator.core.tunnel.DeleteTunnel;
import com.oceanbase.tools.migrator.job.AbstractJob;

public class DeleteJob
extends AbstractJob {
    private CheckTunnel checkTunnel = null;
    private DeleteTunnel deleteTunnel = null;

    @Override
    void processJobInternal() {
        int i;
        this.checkTunnel = new CheckTunnel(this.jobMeta);
        this.deleteTunnel = new DeleteTunnel(this.jobMeta);
        for (i = 0; i < this.jobMeta.getReaderTaskCount(); ++i) {
            ReadDataFromTaskRunner readDataFromTaskRunner = new ReadDataFromTaskRunner();
            readDataFromTaskRunner.setReadTunnel(this.taskTunnel);
            readDataFromTaskRunner.setWriteTunnel(this.checkTunnel);
            readDataFromTaskRunner.setName("Job-" + this.jobMeta.getJobId() + "-DeleteReader-" + i);
            this.childRunners.add(this.getExecutorService().submit(readDataFromTaskRunner));
        }
        for (i = 0; i < this.jobMeta.getReaderTaskCount(); ++i) {
            CheckDataFromRecordRunner checkDataFromRecordRunner = new CheckDataFromRecordRunner();
            checkDataFromRecordRunner.setReadTunnel(this.checkTunnel);
            checkDataFromRecordRunner.setWriteTunnel(this.deleteTunnel);
            checkDataFromRecordRunner.setName("Job-" + this.jobMeta.getJobId() + "-DeleteChecker-" + i);
            this.childRunners.add(this.getExecutorService().submit(checkDataFromRecordRunner));
        }
        for (i = 0; i < this.jobMeta.getWriterTaskCount(); ++i) {
            DeleteDataFromRecordRunner deleteDataFromRecordRunner = new DeleteDataFromRecordRunner();
            deleteDataFromRecordRunner.setReadTunnel(this.deleteTunnel);
            deleteDataFromRecordRunner.setName("Job-" + this.jobMeta.getJobId() + "-DeleteDeleter-" + i);
            this.childRunners.add(this.getExecutorService().submit(deleteDataFromRecordRunner));
        }
    }

    @Override
    void doTimerTask() {
        this.checkTunnel.report();
        this.deleteTunnel.report();
        this.checkTunnel.updateRateLimit();
        this.deleteTunnel.updateRateLimit();
    }
}

