/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.job;

import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.core.runner.ReadDataFromTaskRunner;
import com.oceanbase.tools.migrator.core.runner.WriteDataFromRecordRunner;
import com.oceanbase.tools.migrator.core.tunnel.WriteTunnel;
import com.oceanbase.tools.migrator.job.AbstractJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackJob
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(RollbackJob.class);
    private WriteTunnel writeTunnel = null;

    @Override
    void processJobInternal() {
        int i;
        log.info("Rollback job set MigrationInsertAction INSERT_IGNORE");
        this.jobMeta.getJobParameter().setMigrationInsertAction(MigrationInsertAction.INSERT_IGNORE);
        this.writeTunnel = new WriteTunnel(this.jobMeta);
        for (i = 0; i < this.jobMeta.getReaderTaskCount(); ++i) {
            ReadDataFromTaskRunner readDataFromTaskRunner = new ReadDataFromTaskRunner();
            readDataFromTaskRunner.setReadTunnel(this.taskTunnel);
            readDataFromTaskRunner.setWriteTunnel(this.writeTunnel);
            readDataFromTaskRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackReader-" + i);
            this.childRunners.add(this.getExecutorService().submit(readDataFromTaskRunner));
        }
        for (i = 0; i < this.jobMeta.getWriterTaskCount(); ++i) {
            WriteDataFromRecordRunner writeDataFromRecordRunner = new WriteDataFromRecordRunner();
            writeDataFromRecordRunner.setReadTunnel(this.writeTunnel);
            writeDataFromRecordRunner.setName("Job-" + this.jobMeta.getJobId() + "-RollbackWriter-" + i);
            this.childRunners.add(this.getExecutorService().submit(writeDataFromRecordRunner));
        }
    }

    @Override
    void doTimerTask() {
        this.writeTunnel.report();
        this.writeTunnel.updateRateLimit();
    }
}

