/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.dto;

import com.oceanbase.tools.migrator.common.configure.DirtyRowAction;
import com.oceanbase.tools.migrator.common.enums.MigrationInsertAction;
import com.oceanbase.tools.migrator.common.enums.ShardingStrategy;
import com.oceanbase.tools.migrator.task.CheckMode;
import java.util.LinkedList;
import java.util.List;

public class JobParameter {
    private String migrateRule = null;
    private int readerTaskCount = 5;
    private int writerTaskCount = 8;
    private int readerBatchSize = 200;
    private int writerBatchSize = 100;
    private int subTaskBatchSize = 1000000;
    private int generatorBatchSize = 100000;
    private int multiGetBatchSize = 100;
    private int deleteBatchSize = 100;
    private List<String> migratePartitions = new LinkedList<String>();
    private Boolean enableColumnAutoRepair = false;
    private String minPrimaryKey;
    private ShardingStrategy shardingStrategy = ShardingStrategy.FIXED_LENGTH;
    private MigrationInsertAction migrationInsertAction = MigrationInsertAction.INSERT_NORMAL;
    private DirtyRowAction dirtyRowAction = DirtyRowAction.RAISE_ERROR;
    private CheckMode checkMode = CheckMode.MULTIPLE_GET;

    public int getSubTaskBatchSize() {
        return this.getGeneratorBatchSize() * 10;
    }

    public String getMigrateRule() {
        return this.migrateRule;
    }

    public int getReaderTaskCount() {
        return this.readerTaskCount;
    }

    public int getWriterTaskCount() {
        return this.writerTaskCount;
    }

    public int getReaderBatchSize() {
        return this.readerBatchSize;
    }

    public int getWriterBatchSize() {
        return this.writerBatchSize;
    }

    public int getGeneratorBatchSize() {
        return this.generatorBatchSize;
    }

    public int getMultiGetBatchSize() {
        return this.multiGetBatchSize;
    }

    public int getDeleteBatchSize() {
        return this.deleteBatchSize;
    }

    public List<String> getMigratePartitions() {
        return this.migratePartitions;
    }

    public Boolean getEnableColumnAutoRepair() {
        return this.enableColumnAutoRepair;
    }

    public String getMinPrimaryKey() {
        return this.minPrimaryKey;
    }

    public ShardingStrategy getShardingStrategy() {
        return this.shardingStrategy;
    }

    public MigrationInsertAction getMigrationInsertAction() {
        return this.migrationInsertAction;
    }

    public DirtyRowAction getDirtyRowAction() {
        return this.dirtyRowAction;
    }

    public CheckMode getCheckMode() {
        return this.checkMode;
    }

    public void setMigrateRule(String migrateRule) {
        this.migrateRule = migrateRule;
    }

    public void setReaderTaskCount(int readerTaskCount) {
        this.readerTaskCount = readerTaskCount;
    }

    public void setWriterTaskCount(int writerTaskCount) {
        this.writerTaskCount = writerTaskCount;
    }

    public void setReaderBatchSize(int readerBatchSize) {
        this.readerBatchSize = readerBatchSize;
    }

    public void setWriterBatchSize(int writerBatchSize) {
        this.writerBatchSize = writerBatchSize;
    }

    public void setSubTaskBatchSize(int subTaskBatchSize) {
        this.subTaskBatchSize = subTaskBatchSize;
    }

    public void setGeneratorBatchSize(int generatorBatchSize) {
        this.generatorBatchSize = generatorBatchSize;
    }

    public void setMultiGetBatchSize(int multiGetBatchSize) {
        this.multiGetBatchSize = multiGetBatchSize;
    }

    public void setDeleteBatchSize(int deleteBatchSize) {
        this.deleteBatchSize = deleteBatchSize;
    }

    public void setMigratePartitions(List<String> migratePartitions) {
        this.migratePartitions = migratePartitions;
    }

    public void setEnableColumnAutoRepair(Boolean enableColumnAutoRepair) {
        this.enableColumnAutoRepair = enableColumnAutoRepair;
    }

    public void setMinPrimaryKey(String minPrimaryKey) {
        this.minPrimaryKey = minPrimaryKey;
    }

    public void setShardingStrategy(ShardingStrategy shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
    }

    public void setMigrationInsertAction(MigrationInsertAction migrationInsertAction) {
        this.migrationInsertAction = migrationInsertAction;
    }

    public void setDirtyRowAction(DirtyRowAction dirtyRowAction) {
        this.dirtyRowAction = dirtyRowAction;
    }

    public void setCheckMode(CheckMode checkMode) {
        this.checkMode = checkMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobParameter)) {
            return false;
        }
        JobParameter other = (JobParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$migrateRule = this.getMigrateRule();
        String other$migrateRule = other.getMigrateRule();
        if (this$migrateRule == null ? other$migrateRule != null : !this$migrateRule.equals(other$migrateRule)) {
            return false;
        }
        if (this.getReaderTaskCount() != other.getReaderTaskCount()) {
            return false;
        }
        if (this.getWriterTaskCount() != other.getWriterTaskCount()) {
            return false;
        }
        if (this.getReaderBatchSize() != other.getReaderBatchSize()) {
            return false;
        }
        if (this.getWriterBatchSize() != other.getWriterBatchSize()) {
            return false;
        }
        if (this.getSubTaskBatchSize() != other.getSubTaskBatchSize()) {
            return false;
        }
        if (this.getGeneratorBatchSize() != other.getGeneratorBatchSize()) {
            return false;
        }
        if (this.getMultiGetBatchSize() != other.getMultiGetBatchSize()) {
            return false;
        }
        if (this.getDeleteBatchSize() != other.getDeleteBatchSize()) {
            return false;
        }
        List<String> this$migratePartitions = this.getMigratePartitions();
        List<String> other$migratePartitions = other.getMigratePartitions();
        if (this$migratePartitions == null ? other$migratePartitions != null : !((Object)this$migratePartitions).equals(other$migratePartitions)) {
            return false;
        }
        Boolean this$enableColumnAutoRepair = this.getEnableColumnAutoRepair();
        Boolean other$enableColumnAutoRepair = other.getEnableColumnAutoRepair();
        if (this$enableColumnAutoRepair == null ? other$enableColumnAutoRepair != null : !((Object)this$enableColumnAutoRepair).equals(other$enableColumnAutoRepair)) {
            return false;
        }
        String this$minPrimaryKey = this.getMinPrimaryKey();
        String other$minPrimaryKey = other.getMinPrimaryKey();
        if (this$minPrimaryKey == null ? other$minPrimaryKey != null : !this$minPrimaryKey.equals(other$minPrimaryKey)) {
            return false;
        }
        ShardingStrategy this$shardingStrategy = this.getShardingStrategy();
        ShardingStrategy other$shardingStrategy = other.getShardingStrategy();
        if (this$shardingStrategy == null ? other$shardingStrategy != null : !((Object)((Object)this$shardingStrategy)).equals((Object)other$shardingStrategy)) {
            return false;
        }
        MigrationInsertAction this$migrationInsertAction = this.getMigrationInsertAction();
        MigrationInsertAction other$migrationInsertAction = other.getMigrationInsertAction();
        if (this$migrationInsertAction == null ? other$migrationInsertAction != null : !((Object)((Object)this$migrationInsertAction)).equals((Object)other$migrationInsertAction)) {
            return false;
        }
        DirtyRowAction this$dirtyRowAction = this.getDirtyRowAction();
        DirtyRowAction other$dirtyRowAction = other.getDirtyRowAction();
        if (this$dirtyRowAction == null ? other$dirtyRowAction != null : !((Object)((Object)this$dirtyRowAction)).equals((Object)other$dirtyRowAction)) {
            return false;
        }
        CheckMode this$checkMode = this.getCheckMode();
        CheckMode other$checkMode = other.getCheckMode();
        return !(this$checkMode == null ? other$checkMode != null : !((Object)((Object)this$checkMode)).equals((Object)other$checkMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $migrateRule = this.getMigrateRule();
        result = result * 59 + ($migrateRule == null ? 43 : $migrateRule.hashCode());
        result = result * 59 + this.getReaderTaskCount();
        result = result * 59 + this.getWriterTaskCount();
        result = result * 59 + this.getReaderBatchSize();
        result = result * 59 + this.getWriterBatchSize();
        result = result * 59 + this.getSubTaskBatchSize();
        result = result * 59 + this.getGeneratorBatchSize();
        result = result * 59 + this.getMultiGetBatchSize();
        result = result * 59 + this.getDeleteBatchSize();
        List<String> $migratePartitions = this.getMigratePartitions();
        result = result * 59 + ($migratePartitions == null ? 43 : ((Object)$migratePartitions).hashCode());
        Boolean $enableColumnAutoRepair = this.getEnableColumnAutoRepair();
        result = result * 59 + ($enableColumnAutoRepair == null ? 43 : ((Object)$enableColumnAutoRepair).hashCode());
        String $minPrimaryKey = this.getMinPrimaryKey();
        result = result * 59 + ($minPrimaryKey == null ? 43 : $minPrimaryKey.hashCode());
        ShardingStrategy $shardingStrategy = this.getShardingStrategy();
        result = result * 59 + ($shardingStrategy == null ? 43 : ((Object)((Object)$shardingStrategy)).hashCode());
        MigrationInsertAction $migrationInsertAction = this.getMigrationInsertAction();
        result = result * 59 + ($migrationInsertAction == null ? 43 : ((Object)((Object)$migrationInsertAction)).hashCode());
        DirtyRowAction $dirtyRowAction = this.getDirtyRowAction();
        result = result * 59 + ($dirtyRowAction == null ? 43 : ((Object)((Object)$dirtyRowAction)).hashCode());
        CheckMode $checkMode = this.getCheckMode();
        result = result * 59 + ($checkMode == null ? 43 : ((Object)((Object)$checkMode)).hashCode());
        return result;
    }

    public String toString() {
        return "JobParameter(migrateRule=" + this.getMigrateRule() + ", readerTaskCount=" + this.getReaderTaskCount() + ", writerTaskCount=" + this.getWriterTaskCount() + ", readerBatchSize=" + this.getReaderBatchSize() + ", writerBatchSize=" + this.getWriterBatchSize() + ", subTaskBatchSize=" + this.getSubTaskBatchSize() + ", generatorBatchSize=" + this.getGeneratorBatchSize() + ", multiGetBatchSize=" + this.getMultiGetBatchSize() + ", deleteBatchSize=" + this.getDeleteBatchSize() + ", migratePartitions=" + this.getMigratePartitions() + ", enableColumnAutoRepair=" + this.getEnableColumnAutoRepair() + ", minPrimaryKey=" + this.getMinPrimaryKey() + ", shardingStrategy=" + (Object)((Object)this.getShardingStrategy()) + ", migrationInsertAction=" + (Object)((Object)this.getMigrationInsertAction()) + ", dirtyRowAction=" + (Object)((Object)this.getDirtyRowAction()) + ", checkMode=" + (Object)((Object)this.getCheckMode()) + ")";
    }
}

