/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.element;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.StringColumn;
import com.oceanbase.tools.migrator.common.element.TimeColumn;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class PrimaryKey {
    private final List<Column> primaryKeyColumns;
    private boolean isIncluded = true;
    private static final Pattern PK_VALUE_PATTERN = Pattern.compile("(.*)@(\".*\")$");

    public PrimaryKey(int keyCount) {
        this.primaryKeyColumns = new ArrayList<Column>(keyCount);
    }

    public PrimaryKey() {
        this.primaryKeyColumns = new LinkedList<Column>();
    }

    public PrimaryKey(List<Column> primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public PrimaryKey(List<Column> primaryKeyColumns, Boolean isIncluded) {
        this.primaryKeyColumns = primaryKeyColumns;
        this.isIncluded = isIncluded;
    }

    public boolean isNull() {
        return this.primaryKeyColumns.size() < 1 || this.primaryKeyColumns.get(0) == null;
    }

    public int getColumnCount() {
        if (this.primaryKeyColumns.size() == 1) {
            return 1;
        }
        return this.primaryKeyColumns.size() >= 2 && null == this.primaryKeyColumns.get(1) ? 1 : this.primaryKeyColumns.size();
    }

    public List<Column> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public void setIncluded(boolean included) {
        this.isIncluded = included;
    }

    public void addKeyColumn(Column column) {
        this.primaryKeyColumns.add(column);
    }

    public Column getPrimaryKeyColumn(int index) {
        Column column = null;
        if (this.primaryKeyColumns.size() >= index) {
            column = this.primaryKeyColumns.get(index);
        }
        return column;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("primaryKeyColumns", this.primaryKeyColumns).append("isIncluded", this.isIncluded).toString();
    }

    public String toSqlString() {
        return (this.isIncluded ? "[" : "(") + this.toStringListStr() + (this.isIncluded ? "]" : ")");
    }

    String toStringListStr() {
        StringBuilder builder = new StringBuilder();
        for (Column primaryKeyColumn : this.primaryKeyColumns) {
            if (null == primaryKeyColumn) continue;
            if (builder.length() != 0) {
                builder.append(" , ");
            }
            builder.append((Object)primaryKeyColumn.getType());
            builder.append("@");
            builder.append("\"").append(primaryKeyColumn.getString()).append("\"");
        }
        return builder.toString();
    }

    public static PrimaryKey valuesOf(String strValue) {
        if (strValue == null || strValue.length() <= 2) {
            return null;
        }
        PrimaryKey key = strValue.contains("@") ? PrimaryKey.valuesOfWithType(strValue) : PrimaryKey.valuesOfWithoutType(strValue);
        return key;
    }

    private static PrimaryKey valuesOfWithoutType(String strValue) {
        String[] strArray;
        PrimaryKey key = new PrimaryKey();
        if (strValue.charAt(0) == '(' && strValue.charAt(strValue.length() - 1) == ')') {
            key.setIncluded(false);
        } else if (strValue.charAt(0) == '[' && strValue.charAt(strValue.length() - 1) == ']') {
            key.setIncluded(true);
        } else {
            throw new UnExpectedException("invalid primary key type");
        }
        for (String value : strArray = strValue.substring(1, strValue.length() - 1).split(",")) {
            String trimmedValue = value.trim();
            if (trimmedValue.startsWith("'")) {
                String strColumnValue = trimmedValue.replaceAll("'", "");
                if (strColumnValue.length() <= 0) continue;
                key.getPrimaryKeyColumns().add(new StringColumn(DataType.STRING, strColumnValue));
                continue;
            }
            if (trimmedValue.length() <= 0) continue;
            String longColumnValue = trimmedValue.replaceAll("'", "");
            key.getPrimaryKeyColumns().add(new StringColumn(DataType.NUMBER, longColumnValue));
        }
        return key;
    }

    private static PrimaryKey valuesOfWithType(String strValue) {
        String[] strArray;
        PrimaryKey key = new PrimaryKey();
        if (strValue.charAt(0) == '(' && strValue.charAt(strValue.length() - 1) == ')') {
            key.setIncluded(false);
        } else if (strValue.charAt(0) == '[' && strValue.charAt(strValue.length() - 1) == ']') {
            key.setIncluded(true);
        } else {
            throw new UnExpectedException("invalid primary key type");
        }
        for (String value : strArray = strValue.substring(1, strValue.length() - 1).split(" , ")) {
            String trimmedValue = value.trim();
            Matcher matcher = PK_VALUE_PATTERN.matcher(trimmedValue);
            if (matcher.find()) {
                DataType dataType = DataType.valueOf(matcher.group(1));
                String columnValue = matcher.group(2);
                if (columnValue.startsWith("\"") && columnValue.endsWith("\"")) {
                    columnValue = columnValue.substring(1, columnValue.length() - 1);
                    if (dataType.equals((Object)DataType.NUMBER)) {
                        key.getPrimaryKeyColumns().add(new StringColumn(dataType, columnValue));
                        continue;
                    }
                    if (dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.DATE)) {
                        key.getPrimaryKeyColumns().add(new TimeColumn(dataType, columnValue));
                        continue;
                    }
                    key.getPrimaryKeyColumns().add(new StringColumn(dataType, columnValue));
                    continue;
                }
                throw new DefinedException(ErrorType.INVALID_PK_VALUE, String.format("invalid primary key value [%s]", trimmedValue));
            }
            throw new DefinedException(ErrorType.INVALID_PK_VALUE, String.format("invalid primary key value [%s]", trimmedValue));
        }
        return key;
    }
}

