/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.common.meta;

import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.helper.TableEntryExtractor;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.common.util.OBVersionUtil;
import com.oceanbase.tools.migrator.datasource.DataSourceAdapter;
import com.oceanbase.tools.migrator.table.TableAccessorFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaManager {
    private static final Logger log = LoggerFactory.getLogger(TableMetaManager.class);

    public static TableMeta getTableMeta(DataSourceAdapter ds, String tableName, long tableId) throws Exception {
        try (Connection connection = ds.getConnectionReadOnly();){
            TableMeta tableMeta = new TableMeta();
            tableMeta.setName(tableName);
            tableMeta.setTableId(tableId);
            tableMeta.setDataBaseType(ds.getDataBaseType());
            tableMeta.setSchema(ds.getSchema());
            try {
                List<ColumnMeta> columnMetas = TableAccessorFactory.get(ds.getDataBaseType()).getTableColumns(connection, ds.getSchema(), tableName);
                tableMeta.setColumnMetas(columnMetas);
            }
            catch (Exception e) {
                log.warn("Get table columns failed.", (Throwable)e);
                throw new UnExpectedException("Get table columns failed.");
            }
            tableMeta.setColumnMetaMap(tableMeta.getColumnMetas().stream().collect(Collectors.toMap(ColumnMeta::getName, columnMeta -> columnMeta)));
            try {
                TableMetaManager.initUniqueKey(connection, tableMeta);
            }
            catch (Exception e) {
                log.warn("Get table unique key failed.", (Throwable)e);
                throw new UnExpectedException("Get table unique key failed.");
            }
            if (ds.getDataBaseType().isOceanBase()) {
                tableMeta.setTableEntry(TableMetaManager.getTableEntry(ds, tableName));
            }
            TableMeta tableMeta2 = tableMeta;
            return tableMeta2;
        }
    }

    private static void initUniqueKey(Connection conn, TableMeta tableMeta) throws SQLException {
        List<String> shardKeyColumns;
        String shardKeyName;
        TreeMap<String, List<String>> indexName2Columns = new TreeMap<String, List<String>>(TableAccessorFactory.get(tableMeta.getDataBaseType()).getTableIndex2Columns(conn, tableMeta.getSchema(), tableMeta.getName()));
        if (indexName2Columns.isEmpty()) {
            throw new UnExpectedException("tableUniqueIndexColumns is empty");
        }
        if (indexName2Columns.containsKey("PRIMARY") && tableMeta.getDataBaseType().isMySQL()) {
            shardKeyName = "PRIMARY";
            shardKeyColumns = indexName2Columns.get("PRIMARY");
        } else {
            Map.Entry<String, List<String>> firstEntry = indexName2Columns.firstEntry();
            shardKeyName = firstEntry.getKey();
            shardKeyColumns = firstEntry.getValue();
        }
        tableMeta.setShardKeyName(shardKeyName);
        LinkedList<ColumnMeta> shardKeyColumnMetas = new LinkedList<ColumnMeta>();
        for (int i = 0; i < shardKeyColumns.size(); ++i) {
            String s = shardKeyColumns.get(i).trim();
            ColumnMeta columnMeta = tableMeta.getColumnMetaMap().get(s);
            columnMeta.setShardKeyIndex(i);
            shardKeyColumnMetas.add(columnMeta);
        }
        tableMeta.setShardKeyColumns(shardKeyColumnMetas);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TableEntry getTableEntry(DataSourceAdapter datasource, String tableName) {
        try (Connection conn = datasource.getBackendConnection();){
            TableEntryKey tableEntryKey = new TableEntryKey(datasource.getDataSourceInfo().getClusterName(), datasource.getDataSourceInfo().getTenantName(), datasource.getDataSourceInfo().getDatabaseName(), tableName, ObServerMode.fromMySql((String)datasource.getDbVersion()));
            TableEntryExtractor tableEntryExtractor = new TableEntryExtractor();
            TableEntry tableEntry = tableEntryExtractor.queryTableEntry(conn, tableEntryKey, OBVersionUtil.isGreaterThanOB4X(datasource.getDbVersion()));
            return tableEntry;
        }
        catch (Exception e) {
            log.warn("Get table entry failed,tableName={},errorMsg={}", (Object)tableName, (Object)e.getMessage());
            return null;
        }
    }
}

