/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core;

import com.oceanbase.tools.migrator.common.dto.TaskGenerator;
import com.oceanbase.tools.migrator.common.enums.JobType;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.util.ResourceIdUtils;
import com.oceanbase.tools.migrator.core.IJobStore;
import com.oceanbase.tools.migrator.core.JobMetaFactory;
import com.oceanbase.tools.migrator.core.JobReq;
import com.oceanbase.tools.migrator.core.meta.JobMeta;
import com.oceanbase.tools.migrator.job.AbstractJob;
import com.oceanbase.tools.migrator.job.DeleteJob;
import com.oceanbase.tools.migrator.job.DirectDeleteJob;
import com.oceanbase.tools.migrator.job.Job;
import com.oceanbase.tools.migrator.job.MigrateJob;
import com.oceanbase.tools.migrator.job.QuickDeleteJob;
import com.oceanbase.tools.migrator.job.RollbackJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFactory {
    private static final Logger log = LoggerFactory.getLogger(JobFactory.class);
    private IJobStore jobStore;

    public JobFactory(IJobStore jobStore) {
        this.jobStore = jobStore;
    }

    public Job createJob(JobReq jobReq) {
        try {
            Job job = this.createJob(jobReq.getHistoryJob().getJobType());
            JobMeta jobMeta = JobMetaFactory.create(jobReq);
            jobMeta.setJobService(this.jobStore);
            TaskGenerator generator = this.jobStore.getTaskGenerator(jobReq.getHistoryJob().getTaskGeneratorId(), jobMeta.getJobId());
            if (generator == null) {
                generator = new TaskGenerator();
                generator.setId(ResourceIdUtils.getResourceId("g"));
                generator.setJobId(jobMeta.getJobId());
                this.jobStore.storeTaskGenerator(generator);
                this.jobStore.bindGeneratorToJob(jobMeta.getJobId(), generator);
            }
            jobMeta.setGenerator(generator);
            jobMeta.getJobStat().setRowCount(generator.getProcessedRowCount());
            jobMeta.getJobStat().setDataSize(generator.getProcessedDataSize());
            jobMeta.reportStatistic();
            job.setJobMeta(jobMeta);
            log.info("Create job succeed,DLMJobId={}", (Object)jobMeta.getJobId());
            return job;
        }
        catch (Exception e) {
            log.warn("Create job failed", (Throwable)e);
            throw new UnExpectedException("Create job failed", e);
        }
    }

    private Job createJob(JobType jobType) {
        AbstractJob job;
        switch (jobType) {
            case MIGRATE: {
                job = new MigrateJob();
                break;
            }
            case DELETE: {
                job = new DeleteJob();
                break;
            }
            case ROLLBACK: {
                job = new RollbackJob();
                break;
            }
            case QUICK_DELETE: {
                job = new QuickDeleteJob();
                break;
            }
            case DEIRECT_DELETE: {
                job = new DirectDeleteJob();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown job type: " + (Object)((Object)jobType));
            }
        }
        return job;
    }
}

