/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractSqlBuilder {
    protected String hint = "";
    protected String selectColumns = "";
    protected String tableName = "";
    protected String shardKeyName = "PRIMARY";
    protected List<String> primaryKeyConditions = new ArrayList<String>(2);
    protected List<String> userDefinedConditions = new ArrayList<String>(1);
    protected OrderByMethod orderByMethod = OrderByMethod.NOT_ORDER_BY;
    protected Integer offset = null;
    protected Integer limit = null;
    protected Integer batchSize = null;
    protected String tableOwner = "";
    protected String partitionName = "";
    protected List<ColumnMeta> orderByColumns = null;

    public void addPrimaryKeyCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.primaryKeyConditions.add(condition);
        }
    }

    public void addUserDefinedCondition(String condition) {
        if (condition != null && condition.length() > 0) {
            this.userDefinedConditions.add(condition);
        }
    }

    public String getCondition() {
        StringBuilder sb = new StringBuilder();
        if (!this.primaryKeyConditions.isEmpty()) {
            sb.append(this.buildConditionString(this.primaryKeyConditions));
        }
        if (!this.userDefinedConditions.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(this.buildConditionString(this.userDefinedConditions));
        }
        return sb.toString();
    }

    private String buildConditionString(List<String> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return "";
        }
        List wrappedConditions = conditions.stream().map(condition -> "(" + condition + ")").collect(Collectors.toList());
        return String.join((CharSequence)" AND ", wrappedConditions);
    }

    public abstract String getReadDataSql();

    public abstract String getReadCountSql();

    public abstract String getSqlString(Column var1);

    public abstract String getBatchDeleteSql(TableMeta var1, int var2);

    public abstract String getDeleteSql(TableMeta var1);

    public abstract String getDeleteSql(TableMeta var1, String var2, String var3, int var4);

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setSelectColumns(String selectColumns) {
        this.selectColumns = selectColumns;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setShardKeyName(String shardKeyName) {
        this.shardKeyName = shardKeyName;
    }

    public void setOrderByMethod(OrderByMethod orderByMethod) {
        this.orderByMethod = orderByMethod;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setOrderByColumns(List<ColumnMeta> orderByColumns) {
        this.orderByColumns = orderByColumns;
    }
}

