/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.core.builder.ObMysqlSqlBuilder;
import org.apache.commons.lang.StringUtils;

public class MysqlSqlBuilder
extends ObMysqlSqlBuilder {
    @Override
    public String getReadDataSql() {
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.hint);
        builder.append(" ").append(this.selectColumns);
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.tableName).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (StringUtils.isNotEmpty((String)this.shardKeyName)) {
            builder.append(String.format(" force index(%s) ", this.shardKeyName));
        } else {
            builder.append(" force index(PRIMARY) ");
        }
        builder.append(this.buildCondition());
        return builder.toString();
    }

    @Override
    public String getReadCountSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.hint);
        builder.append(" COUNT(*) ");
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.tableName).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (StringUtils.isNotEmpty((String)this.shardKeyName)) {
            builder.append(String.format(" force index(%s) ", this.shardKeyName));
        } else {
            builder.append(" force index(PRIMARY) ");
        }
        builder.append(this.buildCondition());
        return builder.toString();
    }
}

