/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMysqlSqlBuilder
extends AbstractSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ObMysqlSqlBuilder.class);
    private static final Pattern EXTRACT_NUMBER = Pattern.compile("(?<=\\()[^)]+");
    private static final Pattern EXTRACT_VARCHAR = Pattern.compile("varchar\\((?<length>\\w+)\\)");

    @Override
    public String getReadDataSql() {
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.hint);
        builder.append(" ").append(this.selectColumns);
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.tableName).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        builder.append(this.buildCondition());
        return builder.toString();
    }

    @Override
    public String getReadCountSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.hint);
        builder.append(" COUNT(*) ");
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.tableName).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        builder.append(this.buildCondition());
        return builder.toString();
    }

    protected String buildCondition() {
        String condition;
        StringBuilder builder = new StringBuilder();
        if (!this.userDefinedConditions.isEmpty() || !this.primaryKeyConditions.isEmpty()) {
            builder.append(" WHERE ");
        }
        if (StringUtils.isNotEmpty((String)(condition = this.getCondition()))) {
            builder.append(condition);
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (int i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            if (this.offset != null) {
                builder.append(" ").append(this.offset).append(" ,");
            }
            builder.append(" ").append(this.limit);
        }
        return builder.toString();
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                sqlStr = String.format("'%s'", column.getString());
                break;
            }
            case BYTES: {
                sqlStr = String.format("UNHEX('%s')", DatatypeConverter.printHexBinary((byte[])((byte[])column.getValue())));
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    private String appendEscapeChar(String stringValue) {
        StringBuilder buffer = new StringBuilder((int)((double)stringValue.length() * 1.1));
        buffer.append("'");
        block8: for (char c : stringValue.toCharArray()) {
            switch (c) {
                case '\u0000': {
                    buffer.append('\\');
                    buffer.append('0');
                    continue block8;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block8;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block8;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block8;
                }
                case '\u001a': {
                    buffer.append('\\');
                    buffer.append('Z');
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append("'");
        return buffer.toString();
    }

    private boolean isEscapeNeededForString(Column column) {
        boolean needsHexEscape = false;
        for (char c : column.getString().toCharArray()) {
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM `%s` WHERE ", tableMeta.getName(), tableMeta.getShardKeyName(), tableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getSingleGetCondition(tableMeta.getShardKeyColumns(), tableMeta.getDataBaseType());
        return deleteSql;
    }

    @Override
    public String getBatchDeleteSql(TableMeta tableMeta, int batchSize) {
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM `%s` WHERE ", tableMeta.getName(), tableMeta.getShardKeyName(), tableMeta.getName());
        deleteSql = deleteSql + SqlUtils.getMultiGetCondition(tableMeta.getShardKeyColumns(), batchSize, tableMeta.getDataBaseType());
        return deleteSql;
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta, String part, String condition, int batchSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM `").append(tableMeta.getName()).append("`");
        if (StringUtils.isNotEmpty((String)part)) {
            sb.append(" PARTITION(").append(part).append(")");
        }
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" WHERE ").append(condition);
        }
        sb.append(" LIMIT ").append(batchSize);
        return sb.toString();
    }
}

