/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.core.builder.OracleSqlBuilder;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleSqlBuilder
extends OracleSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ObOracleSqlBuilder.class);

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: {
                sqlStr = String.format("TO_DATE('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss");
                break;
            }
            case TIMESTAMP: {
                sqlStr = String.format("TO_TIMESTAMP('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss.ff");
                break;
            }
            case BYTES: {
                sqlStr = String.format("HEXTORAW('%s')", DatatypeConverter.printHexBinary((byte[])((byte[])column.getValue())));
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }
}

