/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSqlBuilder
extends AbstractSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(OracleSqlBuilder.class);

    @Override
    public String getDeleteSql(TableMeta tableMeta) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE /*+ index(");
        sb.append(tableMeta.getName());
        sb.append(" ");
        sb.append(tableMeta.getShardKeyName());
        sb.append(") */ FROM ");
        sb.append(SqlUtils.quoteOracleIdentifier(tableMeta.getSchema()));
        sb.append(".");
        sb.append(SqlUtils.quoteOracleIdentifier(tableMeta.getName()));
        sb.append(" WHERE ");
        sb.append(SqlUtils.getSingleGetCondition(tableMeta.getShardKeyColumns(), tableMeta.getDataBaseType()));
        return sb.toString();
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta, String part, String condition, int batchSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(SqlUtils.quoteOracleIdentifier(tableMeta.getName()));
        sb.append(" WHERE ROWID IN(SELECT ROWID FROM ").append(SqlUtils.quoteOracleIdentifier(tableMeta.getName()));
        sb.append(" WHERE ROWNUM <= ").append(batchSize);
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append(" AND ").append(condition);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getBatchDeleteSql(TableMeta tableMeta, int batchSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE /*+ index(");
        sb.append(tableMeta.getName());
        sb.append(" ");
        sb.append(tableMeta.getShardKeyName());
        sb.append(") */ FROM ");
        sb.append(SqlUtils.quoteOracleIdentifier(tableMeta.getSchema()));
        sb.append(".");
        sb.append(SqlUtils.quoteOracleIdentifier(tableMeta.getName()));
        sb.append(" WHERE ");
        sb.append(SqlUtils.getMultiGetCondition(tableMeta.getShardKeyColumns(), batchSize, DataBaseType.ORACLE));
        return sb.toString();
    }

    @Override
    public String getReadCountSql() {
        String condition;
        if (StringUtils.isEmpty((String)this.tableOwner) || StringUtils.isEmpty((String)this.tableName)) {
            log.info("Table owner or name cannot be empty,tableOwner={},tableName={}", (Object)this.tableOwner, (Object)this.tableName);
            throw new UnExpectedException("Table owner or name cannot be empty.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT COUNT (*) FROM ");
        builder.append(SqlUtils.quoteOracleIdentifier(this.tableOwner.toUpperCase()));
        builder.append(".");
        builder.append(SqlUtils.quoteOracleIdentifier(this.tableName.toUpperCase()));
        if (StringUtils.isNotEmpty((String)this.partitionName)) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (StringUtils.isNotEmpty((String)(condition = this.getCondition()))) {
            builder.append(" WHERE ");
            builder.append(condition);
        }
        return builder.toString();
    }

    @Override
    public String getReadDataSql() {
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0 || this.tableOwner.length() <= 0) {
            throw new UnExpectedException("columnList, tableOwner, tableName cat not be null");
        }
        String sql = this.getReadSql();
        return this.batchSize == null ? sql : this.getReadSqlWithRowNum(sql);
    }

    private String getReadSql() {
        String condition;
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (StringUtils.isNotEmpty((String)this.hint)) {
            builder.append(this.hint);
        }
        builder.append(" ").append(this.selectColumns);
        builder.append(" FROM ");
        builder.append(SqlUtils.quoteOracleIdentifier(this.getTableOwner().toUpperCase()));
        builder.append(".");
        builder.append(SqlUtils.quoteOracleIdentifier(this.tableName.toUpperCase()));
        if (StringUtils.isNotEmpty((String)this.partitionName)) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        if (StringUtils.isNotEmpty((String)(condition = this.getCondition()))) {
            builder.append(" WHERE ");
            builder.append(condition);
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ORDER BY ");
            builder.append(this.orderByColumns.stream().map(col -> SqlUtils.quoteOracleIdentifier(col.getName()) + " " + (Object)((Object)this.orderByMethod)).collect(Collectors.joining(",")));
        }
        return builder.toString();
    }

    private String getReadSqlWithRowNum(String readSql) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.selectColumns);
        builder.append(" FROM (");
        builder.append(readSql);
        builder.append(") T1 WHERE ROWNUM <= ");
        builder.append(this.batchSize);
        return builder.toString();
    }

    public String getBoundSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.selectColumns);
        builder.append(" FROM (");
        builder.append("SELECT RECON,");
        builder.append(this.selectColumns);
        builder.append(" FROM (");
        builder.append("SELECT ROWNUM AS RECON,");
        builder.append(this.selectColumns);
        builder.append(" FROM (");
        builder.append(this.getReadSql());
        builder.append(") T1 WHERE ROWNUM <= ");
        builder.append(this.batchSize);
        builder.append(") T2 ORDER BY RECON DESC");
        builder.append(") WHERE ROWNUM = 1");
        return builder.toString();
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    @Override
    public void setTableOwner(String tableOwner) {
        this.tableOwner = tableOwner;
    }

    @Override
    public void setOrderByColumns(List<ColumnMeta> orderByColumns) {
        this.orderByColumns = orderByColumns;
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case BOOL: {
                sqlStr = column.getString();
                break;
            }
            case STRING: {
                if (!this.isEscapeNeededForString(column)) {
                    sqlStr = String.format("'%s'", column.getString());
                    break;
                }
                sqlStr = this.appendEscapeChar(column.getString());
                break;
            }
            case DATE: {
                sqlStr = String.format("TO_DATE('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss");
                break;
            }
            case TIMESTAMP: {
                sqlStr = String.format("TO_TIMESTAMP('%s','%s')", column.getString(), "yyyy-mm-dd hh24:mi:ss.ff");
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    protected String appendEscapeChar(String stringValue) {
        StringBuilder buffer = new StringBuilder((int)((double)stringValue.length() * 1.1));
        buffer.append("'");
        block8: for (char c : stringValue.toCharArray()) {
            switch (c) {
                case '\u0000': {
                    buffer.append('\\');
                    buffer.append('0');
                    continue block8;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block8;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block8;
                }
                case '\'': {
                    buffer.append('\'');
                    buffer.append('\'');
                    continue block8;
                }
                case '\u001a': {
                    buffer.append('\\');
                    buffer.append('Z');
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append("'");
        return buffer.toString();
    }

    protected boolean isEscapeNeededForString(Column column) {
        boolean needsHexEscape = false;
        for (char c : column.getString().toCharArray()) {
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }
}

