/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.builder;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.exception.UnExpectedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.builder.AbstractSqlBuilder;
import com.oceanbase.tools.migrator.core.builder.OrderByMethod;
import com.oceanbase.tools.migrator.sql.SqlUtils;
import org.apache.commons.lang.StringUtils;

public class PostgresSqlBuilder
extends AbstractSqlBuilder {
    protected String buildSqlStatement() {
        if (this.selectColumns.length() <= 0 || this.tableName.length() <= 0) {
            throw new UnExpectedException("columnList and tableName");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.selectColumns);
        builder.append(" ").append("FROM");
        if (this.partitionName.length() > 0) {
            builder.append(" ").append(this.partitionName);
        } else {
            builder.append(" ").append(this.tableName);
        }
        if (!this.userDefinedConditions.isEmpty() || !this.primaryKeyConditions.isEmpty()) {
            builder.append(" ").append("WHERE");
        }
        int conditionCount = 0;
        for (String userDefinedCondition : this.userDefinedConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(userDefinedCondition).append(")");
            ++conditionCount;
        }
        for (String primaryKeyCondition : this.primaryKeyConditions) {
            if (conditionCount > 0) {
                builder.append(" ").append("AND");
            }
            builder.append(" (").append(primaryKeyCondition).append(")");
            ++conditionCount;
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (int i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            builder.append(" ").append(this.limit);
            if (this.offset != null) {
                builder.append(" ").append("offset");
                builder.append(" ").append(this.offset);
            }
        }
        return builder.toString();
    }

    @Override
    public String getReadDataSql() {
        return this.buildSqlStatement();
    }

    @Override
    public String getReadCountSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT");
        builder.append(" ").append(this.hint);
        builder.append(" COUNT(*) ");
        builder.append(" ").append("FROM");
        builder.append(" `").append(this.tableName).append("`");
        if (this.partitionName.length() > 0) {
            builder.append(" PARTITION(");
            builder.append(this.partitionName);
            builder.append(") ");
        }
        builder.append(this.buildCondition());
        return builder.toString();
    }

    protected String buildCondition() {
        String condition;
        StringBuilder builder = new StringBuilder();
        if (!this.userDefinedConditions.isEmpty() || !this.primaryKeyConditions.isEmpty()) {
            builder.append(" WHERE ");
        }
        if (StringUtils.isNotEmpty((String)(condition = this.getCondition()))) {
            builder.append(condition);
        }
        if (this.orderByMethod != OrderByMethod.NOT_ORDER_BY) {
            builder.append(" ").append("ORDER BY ");
            for (int i = 0; i < this.orderByColumns.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(((ColumnMeta)this.orderByColumns.get(i)).getName()).append(" ").append((Object)this.orderByMethod);
            }
        }
        if (this.limit != null) {
            builder.append(" ").append("LIMIT");
            if (this.offset != null) {
                builder.append(" ").append(this.offset).append(" ,");
            }
            builder.append(" ").append(this.limit);
        }
        return builder.toString();
    }

    @Override
    public String getSqlString(Column column) {
        String sqlStr;
        switch (column.getType()) {
            case NUMBER: 
            case DOUBLE: 
            case LONG: 
            case BOOL: 
            case STRING: {
                sqlStr = column.getString();
                break;
            }
            default: {
                sqlStr = String.format("'%s'", column.getString());
            }
        }
        return sqlStr;
    }

    @Override
    public String getBatchDeleteSql(TableMeta tableMeta, int batchSize) {
        String tableName = tableMeta.getName();
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM %s WHERE ", SqlUtils.quotePostgresIdentifier(tableName), tableMeta.getShardKeyName(), tableName);
        deleteSql = deleteSql + SqlUtils.getMultiGetCondition(tableMeta.getShardKeyColumns(), batchSize, DataBaseType.POSTGRESQL);
        return deleteSql;
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta) {
        String tableName = tableMeta.getName();
        String deleteSql = String.format("DELETE /*+ index(%s %s) */ FROM \"%s\" WHERE ", tableName, tableMeta.getShardKeyName(), tableName);
        deleteSql = deleteSql + SqlUtils.getSingleGetCondition(tableMeta.getShardKeyColumns(), tableMeta.getDataBaseType());
        return deleteSql;
    }

    @Override
    public String getDeleteSql(TableMeta tableMeta, String part, String condition, int batchSize) {
        StringBuilder sb = new StringBuilder();
        String indexColumnName = tableMeta.getShardKeyColumns().get(0).getName();
        String tableName = StringUtils.isNotEmpty((String)part) ? part : tableMeta.getName();
        sb.append("delete from ").append(tableName).append(" ");
        sb.append("where ");
        sb.append(indexColumnName).append(" ");
        sb.append("in ").append("(");
        sb.append("select ").append(indexColumnName).append(" ");
        sb.append("from ").append(tableName).append(" ");
        if (StringUtils.isNotEmpty((String)condition)) {
            sb.append("where ").append(condition).append(" ");
        }
        sb.append("order by ").append(tableMeta.getPkColumnListStr()).append(" ");
        sb.append("limit ").append(batchSize).append(" )");
        return sb.toString();
    }
}

