/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.converter;

import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.enums.DataBaseType;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.meta.ColumnMeta;
import com.oceanbase.tools.migrator.common.meta.TableMeta;
import com.oceanbase.tools.migrator.core.converter.AbstractColumnConverter;
import com.oceanbase.tools.migrator.core.converter.ObMysqlColumnConverter;
import com.oceanbase.tools.migrator.core.converter.ObOracleColumnConverter;
import com.oceanbase.tools.migrator.core.converter.PostgresColumnConverter;
import com.oceanbase.tools.migrator.core.data.Row;
import com.oceanbase.tools.migrator.core.data.TransRows;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnConverter {
    private static final Logger log = LoggerFactory.getLogger(ColumnConverter.class);

    public static void convert(TransRows transRows) throws SQLException {
        DataBaseType targetDbType = transRows.getOwnerTaskMeta().getJobMeta().getTargetAdapter().getDataBaseType();
        TableMeta targetTableMeta = transRows.getOwnerTaskMeta().getJobMeta().getTargetTableMeta();
        List<ColumnMeta> columnMetas = targetTableMeta.getColumnMetas();
        for (int i = 0; i < transRows.getBatchRowsCount(); ++i) {
            List<Row> rows = transRows.getBatchRows(i).getRows();
            for (Row row : rows) {
                List<Column> columnList = row.getColumnList();
                for (int j = 0; j < columnMetas.size(); ++j) {
                    ColumnMeta columnMeta = columnMetas.get(j);
                    Column column = columnList.get(columnMeta.getColIdx());
                    Column newColumn = ColumnConverter.getDataConvertHandler(targetDbType).convertColumn(column, columnMeta.getType());
                    row.getColumnList().set(j, newColumn);
                }
            }
        }
    }

    public static List<Column> getConvertColumnsByDbType(List<Column> columns, DataBaseType targetDbType, TableMeta targetTableMeta) {
        ArrayList<Column> convertColumns = new ArrayList<Column>();
        List<ColumnMeta> columnMetas = targetTableMeta.getColumnMetas();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnMeta columnMeta = columnMetas.get(i);
            Column column = columns.get(columnMeta.getColIdx());
            Column newColumn = ColumnConverter.getDataConvertHandler(targetDbType).convertColumn(column, columnMeta.getType());
            convertColumns.add(newColumn);
        }
        return convertColumns;
    }

    private static AbstractColumnConverter getDataConvertHandler(DataBaseType dbType) {
        switch (dbType) {
            case OB_MYSQL: 
            case MYSQL: {
                return new ObMysqlColumnConverter();
            }
            case ORACLE: 
            case OB_ORACLE: {
                return new ObOracleColumnConverter();
            }
            case POSTGRESQL: {
                return new PostgresColumnConverter();
            }
        }
        throw new DefinedException(ErrorType.NOT_SUPPORT, "unsupported type for different db convert");
    }
}

