/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.converter;

import com.oceanbase.tools.migrator.common.element.BytesColumn;
import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.StringColumn;
import com.oceanbase.tools.migrator.common.element.TimeColumn;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.common.util.BitStringUtils;
import com.oceanbase.tools.migrator.core.converter.AbstractColumnConverter;

public class ObMysqlColumnConverter
extends AbstractColumnConverter {
    @Override
    public Column convert(Column column, DataType dataType) {
        Column newColumn;
        this.checkSupported(column.getType());
        switch (dataType) {
            case NUMBER: 
            case DECIMAL: {
                newColumn = new StringColumn(DataType.NUMBER, column.getString());
                break;
            }
            case STRING: 
            case JSON: {
                newColumn = new StringColumn(DataType.STRING, column.getString());
                break;
            }
            case MYSQL_TIMESTAMP: 
            case TIMESTAMP: 
            case DATETIME: {
                newColumn = new StringColumn(DataType.MYSQL_TIMESTAMP, column.getString());
                break;
            }
            case DOUBLE: {
                newColumn = new StringColumn(DataType.DOUBLE, column.getString());
                break;
            }
            case BYTES: {
                if (column.getValue() == null) {
                    newColumn = new BytesColumn(DataType.BYTES, null);
                    break;
                }
                if (column.getType() == DataType.BIT) {
                    byte[] bytes = BitStringUtils.bitStringToByteArray(column.getString());
                    newColumn = new BytesColumn(DataType.BYTES, bytes);
                    break;
                }
                newColumn = new BytesColumn(DataType.BYTES, (byte[])column.getValue());
                break;
            }
            case TIME: {
                newColumn = new TimeColumn(DataType.TIME, column.getString());
                break;
            }
            case DATE: {
                newColumn = new TimeColumn(DataType.DATE, column.getString());
                break;
            }
            default: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "" + (Object)((Object)column.getType()));
            }
        }
        return newColumn;
    }

    @Override
    public void checkSupported(DataType dataType) {
        switch (dataType) {
            case NUMBER: 
            case DECIMAL: 
            case STRING: 
            case JSON: 
            case MYSQL_TIMESTAMP: 
            case TIMESTAMP: 
            case DATETIME: 
            case DOUBLE: 
            case BYTES: 
            case TIME: 
            case DATE: 
            case LONG: 
            case BIT: {
                return;
            }
        }
        throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type for different database archiving: " + (Object)((Object)dataType));
    }
}

