/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.migrator.core.converter;

import com.oceanbase.tools.migrator.common.element.BytesColumn;
import com.oceanbase.tools.migrator.common.element.Column;
import com.oceanbase.tools.migrator.common.element.DataType;
import com.oceanbase.tools.migrator.common.element.StringColumn;
import com.oceanbase.tools.migrator.common.element.TimeColumn;
import com.oceanbase.tools.migrator.common.enums.ErrorType;
import com.oceanbase.tools.migrator.common.exception.DefinedException;
import com.oceanbase.tools.migrator.core.converter.AbstractColumnConverter;

public class ObOracleColumnConverter
extends AbstractColumnConverter {
    @Override
    public Column convert(Column column, DataType dataType) {
        Column newColumn;
        switch (dataType) {
            case STRING: {
                newColumn = new StringColumn(DataType.STRING, column.getString());
                break;
            }
            case NUMBER: {
                newColumn = new StringColumn(DataType.NUMBER, column.getString());
                break;
            }
            case DECIMAL: {
                newColumn = new StringColumn(DataType.DECIMAL, column.getString());
                break;
            }
            case DOUBLE: {
                newColumn = new StringColumn(DataType.DOUBLE, column.getString());
                break;
            }
            case BYTES: {
                if (column.getValue() == null) {
                    newColumn = new StringColumn(DataType.STRING, null);
                    break;
                }
                newColumn = new BytesColumn(DataType.BYTES, (byte[])column.getValue());
                break;
            }
            case TIME: {
                newColumn = new TimeColumn(DataType.TIME, column.getString());
                break;
            }
            case TIMESTAMP: {
                newColumn = new TimeColumn(DataType.TIMESTAMP, column.getString());
                break;
            }
            case DATE: {
                newColumn = new TimeColumn(DataType.DATE, column.getString());
                break;
            }
            case INTERVAL_YM: {
                newColumn = new TimeColumn(DataType.INTERVAL_YM, column.getString());
                break;
            }
            case INTERVAL_DS: {
                newColumn = new TimeColumn(DataType.INTERVAL_DS, column.getString());
                break;
            }
            default: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "" + (Object)((Object)column.getType()));
            }
        }
        return newColumn;
    }

    @Override
    public void checkSupported(DataType dataType) {
        switch (dataType) {
            case STRING: 
            case NUMBER: 
            case DECIMAL: 
            case DOUBLE: 
            case BYTES: 
            case TIME: 
            case TIMESTAMP: 
            case DATE: 
            case INTERVAL_YM: 
            case INTERVAL_DS: {
                break;
            }
            default: {
                throw new DefinedException(ErrorType.NOT_SUPPORT, "not support this data type for different database archiving: " + (Object)((Object)dataType));
            }
        }
    }
}

